% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_table.R
\name{plot_table}
\alias{plot_table}
\title{Prepares pedigree data for plotting and spatial representation}
\usage{
plot_table(
  plot_fams = "all",
  all_fams,
  ped,
  sampledata,
  datacolumns = c("Sample", "AnimalRef", "GeneticSex", "Date", "SType", "lat", "lng",
    "FirstSeen", "LastSeen", "IsDead"),
  deadSample = c("Tissue")
)
}
\arguments{
\item{plot_fams}{Character string or numeric vector. FamID numbers from \code{fams} data generated by \code{\link[=org_fams]{org_fams()}} function.
If all families want to be plotted it is defined as character string "all". For a subset of families
a numeric vector of FamIDs has to be specified. Defaults to "all".}

\item{all_fams}{Data frame. Family (\code{fams}) data generated by \code{\link[=org_fams]{org_fams()}} function.}

\item{ped}{Data frame. Organized pedigree (\code{ped}) generated by \code{\link[=org_fams]{org_fams()}} function.}

\item{sampledata}{Data frame. Metadata for all genetic samples that belong
to the individuals included in pedigree reconstruction analysis.
For description of \code{sampledata} structure and sample information needed for \code{plot_table()} see Details.}

\item{datacolumns}{Vector of column names included \code{sampledata} that are needed to produce
this functions output (see Details).}

\item{deadSample}{Single value or vector of different lethal sample types.
Defaults to c("Tissue").}
}
\value{
Extended \code{sampledata} data frame that includes all columns defined in \code{datacolumns}
parameter and adds information needed for visual and spatial representation of
pedigree:
\itemize{
\item \code{plottingID}: Numeric. Identifier number for temporal pedigree plot
\code{\link[=ped_satplot]{ped_satplot()}}. In case of polygamous animals same individual
can be included in more than one family.
\item \code{FamID}: Numeric. Identifier number of family that individual belongs to.
\item \code{hsGroup}: Numeric. Identifier number for the half-sib group of individual.
\item \code{rep}: Logical. Is individual reproductive in current family,
(current family defined with \code{FamID} for a particular entry).
\item \code{later_rep}: Logical. Is individual reproductive in any other (later) families.
\item \code{isPolygamous}: Logical. Does the individual have more than one mate.
\item \code{dead}: Logical. Is individual dead.
\item \code{first_sample}: Logical. Is this particular sample the first sample of the individual.
\item \code{last_sample}: Logical. Is this particular sample the last sample of the individual.
\item \code{isReference}: Logical. Is this particular sample reference sample of individual.
}
}
\description{
Combines extended pedigree (obtained by \code{\link[=org_fams]{org_fams()}} function)
and sample metadata data for visual (\code{\link[=ped_satplot]{ped_satplot()}}) and spatial
(\code{\link[=ped_spatial]{ped_spatial()}}) representation of the pedigree.
}
\details{
\itemize{
\item \code{sampledata} has to include columns that contain information on:
\itemize{
\item unique identifier of each sample; character or numeric
(default column name = \code{Sample}, see \code{\link[=check_sampledata]{check_sampledata()}} function),
\item date of sample collection in \code{Date} format (default = \code{Date}),
\item assignment of sample to particular individual; character or numeric
(default = \code{AnimalRef}, see \code{\link[=check_sampledata]{check_sampledata()}} function),
\item sex of the animal coded as \code{F}, \code{M} or \code{NA}; character
(default = \code{GeneticSex}, see \code{\link[=check_sampledata]{check_sampledata()}} function),
\item longitude and latitude coordinates of sample collection location; numeric
(default = \code{lng} and \code{lat}, see \code{\link[=check_sampledata]{check_sampledata()}} function),
\item type of particular sample eg. scat, tissue, saliva; character
(default = \code{SType}, see \code{\link[=check_sampledata]{check_sampledata()}} function),
\item date of first and last sample of individual in \code{Date} format
(default = \code{FirstSeen} and \code{LastSeen}, see \code{\link[=anim_timespan]{anim_timespan()}} function),
\item value identifying if if the individual is dead; logical
(default = \code{IsDead}, see \code{\link[=anim_timespan]{anim_timespan()}} function).
}
}
}
\examples{

# Prepare the data for usage with plot_table() function.
# Get animal timespan data using the anim_timespan() function.
animal_ts <- anim_timespan(wolf_samples$AnimalRef,
  wolf_samples$Date,
  wolf_samples$SType,
  dead = c("Tissue")
)
# Add animal timespan to the sampledata
sampledata <- merge(wolf_samples, animal_ts, by.x = "AnimalRef", by.y = "ID", all.x = TRUE)
# Define the path to the pedigree data file.
path <- paste0(system.file("extdata", package = "wpeR"), "/wpeR_samplePed")
# Retrieve the pedigree data from the get_colony function.
ped_colony <- get_colony(path, sampledata, rm_obsolete_parents = TRUE, out = "FamAgg")
# Organize families and expand pedigree data using the org_fams function.
org_tables <- org_fams(ped_colony, sampledata, output = "both")

# Run the function
# Prepare data for plotting.
plot_table(plot_fams = "all",
  org_tables$fams,
  org_tables$ped,
  sampledata,
  deadSample = c("Tissue")
)


}
