% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantile_correlation.R
\name{apply_quantile_correlation}
\alias{apply_quantile_correlation}
\title{Apply Quantile Correlation Analysis}
\usage{
apply_quantile_correlation(data, quantiles, wf = "la8", J = 8, n_sim = 1000)
}
\arguments{
\item{data}{Data frame containing the time series data. The first column is the reference series; subsequent columns are the target series.}

\item{quantiles}{Numeric vector of quantiles.}

\item{wf}{Wavelet family name.}

\item{J}{Decomposition level.}

\item{n_sim}{Number of simulations for confidence intervals.}
}
\value{
A combined data.frame of quantile correlation results, with one row per level-quantile-series combination.
}
\description{
Apply Quantile Correlation Analysis
}
\examples{
data <- data.frame(x = rnorm(1000), y = rnorm(1000), z = rnorm(1000))
quantiles <- c(0.05, 0.5, 0.95)
res_df <- apply_quantile_correlation(data, quantiles,n_sim=10)
head(res_df)
}
