% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BNF.R
\name{compileShortPT}
\alias{compileShortPT}
\title{Produces a production table with non-recursive productions only.}
\usage{
compileShortPT(G)
}
\arguments{
\item{G}{A grammar with symbol table \code{ST}, 
production table \code{PT}, 
and start symbol \code{Start}.}
}
\value{
A (short) production table is a named list with 2 columns.
        The first column
        (the left-hand side \code{LHS}) is a vector
        of non-terminal identifiers. 
        The second column
        (the right-hand side \code{RHS}) is a 
        vector of vectors of numerical identifiers. 
        \code{LHS[i]} derives into \code{RHS[i]}.
}
\description{
\code{compileShortPT()} produces a ``short'' production table 
              from a context-free grammar. The short production table does not
              contain recursive production rules.  
              Warning: No error checking implemented.
}
\details{
\code{compileShortPT()} starts with production rules whose 
         right-hand side contains only terminals. 
         It incrementally builds up the new PT until in the new PT 
         at least one
         production rule exists for each non-terminal 
         which replaces the non-terminal symbol by a list 
         of terminal symbols.

         The short production rule table provides for each non-terminal 
         symbol a minimal finite derivation into terminals. 
         It contains a finite subset of the context-free language 
         as defined by the grammar \code{G}.
         Instead
         of the full production table, it is used
         for generating depth-bounded derivation trees.
         The first idea of defining such a finite part of the language
         is due to M. P. Schützenberger (1966).
}
\examples{
g<-compileBNF(booleanGrammar())
compileShortPT(g)

}
\references{
Schützenberger, M. P. (1966): 
        Classification of Chomsky Languages. In: 
        Steel, T. B. Jr. (Ed.) 
        Formal Language Description Languages for Computer Programming. 
        Proceedings of the IFIP Workshop on Formal 
        Language Description Languages.
        North-Holland, Amsterdam, 100 -104.
}
\seealso{
Other Compiler Steps: 
\code{\link{makeProductionTable}()},
\code{\link{makeStartSymbol}()},
\code{\link{makeSymbolTable}()}
}
\concept{Compiler Steps}
