% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derivationTrees.R
\name{chooseNode}
\alias{chooseNode}
\title{Randomly selects an attributed node in an attributed node list.}
\usage{
chooseNode(ANL)
}
\arguments{
\item{ANL}{Attributed node list.}
}
\value{
An attributed node.
}
\description{
\code{chooseNode()} returns  a random attributed node 
             from an attributed node list.
}
\details{
An attributed \code{node} has the following elements:
    \itemize{
       \item \code{ID}
       \item \code{NonTerminal}
       \item \code{Pos}
       \item \code{Depth}
       \item \code{Rdepth}
       \item \code{subtreedepth}
       \item \code{Index}
       }
   These elements can be used e.g. 
   \itemize{
       \item for inserting and extracting subtrees 
       (\code{Pos} or  \code{node$Index}), 
       \item for checking
             the feasibility of subtree substitution (\code{ID}),
       \item for checking depth bounds 
             (\code{Depth}, \code{RDepth}, and \code{subtreedepth}),
             \dots
       }
}
\examples{
g<-compileBNF(booleanGrammar())
a<-randomDerivationTree(g$Start, g)
b<-treeANL(a, g$ST)
c<-chooseNode(b$ANL)

}
\seealso{
Other Random Choice: 
\code{\link{chooseRule}()}
}
\concept{Random Choice}
