% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xgx_geom_ci.R
\name{xgx_geom_ci}
\alias{xgx_geom_ci}
\title{Plot data with mean and confidence intervals}
\usage{
xgx_geom_ci(
  mapping = NULL,
  data = NULL,
  conf_level = 0.95,
  distribution = "normal",
  bins = NULL,
  breaks = NULL,
  geom = list("point", "line", "errorbar"),
  position = "identity",
  fun.args = list(),
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by `aes` or `aes_`. 
If specified and `inherit.aes = TRUE` (the default), it is combined with the 
default mapping at the top level of the plot. You must supply mapping if 
there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three options:

If NULL, the default, the data is inherited from the plot data as specified 
in the call to ggplot.

A data.frame, or other object, will override the plot data. All objects 
will be fortified to produce a data frame. See fortify for which variables 
will be created.

A function will be called with a single argument, the plot data. The return 
value must be a data.frame., and will be used as the layer data.}

\item{conf_level}{The percentile for the confidence interval (should fall 
between 0 and 1). The default is 0.95, which corresponds to a 95 percent 
confidence interval.}

\item{distribution}{The distribution which the data follow, used for 
calculating confidence intervals. The options are "normal", "lognormal", 
and "binomial". The "normal" option will use the Student t Distribution 
to calculate confidence intervals, the "lognormal" option will transform 
data to the log space first. The "binomial" option will use the
\code{\link[binom:binom.confint]{binom.exact}} function to calculate the
confidence 
intervals. Note: binomial data must be numeric and contain only 1's and 0's.}

\item{bins}{number of bins to cut up the x data, cuts data into quantiles.}

\item{breaks}{breaks to cut up the x data, if this option is used, bins is ignored}

\item{geom}{Use to override the default geom. Can be a list of multiple 
geoms, e.g. list("point","line","errorbar"), which is the default.}

\item{position}{Position adjustment, either as a string, or the result of 
a call to a position adjustment function.}

\item{fun.args}{Optional additional arguments passed on to the functions.}

\item{na.rm}{If FALSE, the default, missing values are removed with a 
warning. If TRUE, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends? 
NA, the default, includes if any aesthetics are mapped. FALSE never 
includes, and TRUE always includes.}

\item{inherit.aes}{If FALSE, overrides the default aesthetics, rather 
than combining with them. This is most useful for helper functions that 
define both data and aesthetics and shouldn't inherit behaviour from the 
default plot specification, e.g. borders.}

\item{...}{other arguments passed on to layer. These are often aesthetics, 
used to set an aesthetic to a fixed value, like color = "red" or size = 3. 
They may also be parameters to the paired geom/stat.}
}
\value{
ggplot2 plot layer
}
\description{
Plot data with mean and confidence intervals
}
\examples{
data <- data.frame(x = rep(c(1, 2, 3), each = 20),
                   y = rep(c(1, 2, 3), each = 20) + stats::rnorm(60))
ggplot2::ggplot(data, ggplot2::aes(x = x, y = y)) + 
  xgx_geom_ci(conf_level = 0.95)
 
}
