% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xml_convert.r
\name{df_to_xml}
\alias{df_to_xml}
\title{Converting XML to data frames and vice versa}
\usage{
df_to_xml(
  df,
  fields = "tags",
  record.tag = "record",
  field.names = NULL,
  only.fields = NULL,
  exclude.fields = NULL,
  root.node = "root",
  xml.file = NULL,
  non.exist = NULL,
  encoding = "UTF-8",
  no.return = FALSE
)
}
\arguments{
\item{df}{Dataframe to be converted to XML}

\item{fields}{A character value, either \code{"tags"} or \code{"attributes"}.
Specifies whether the fields of each data record will be represented in the
resulting XML document by XML tags or by attributes. See the \emph{Details}
section of \code{\link{df_to_xml}()} for more on this topic. Default is
\code{"tags"}}

\item{record.tag}{Name of the tags that will represent the data records in
the resulting XML (i.e. each record has one element with this tag name).}

\item{field.names}{Names of the fields in the XML file. If \code{NULL} then
the variable names from the dataframe are used. Field names are corrected
automatically to comply with XML naming requirements.}

\item{only.fields}{Optional vector variable names from the dataframe that
will be included in the XML document. If \code{NULL} then all fields from
the dataframe are included in the XML document.}

\item{exclude.fields}{Optional vector of variable names from the dataframe
that will not be included in the XML document.}

\item{root.node}{A character value with the desired name of the root element
of the XML document; \code{"root"} by default.}

\item{xml.file}{Name of a file the XML document it written to. If \code{NULL}
no file will be created.}

\item{non.exist}{Value that will be written into the XML document as field
value in case the respective element in the dataframe is \code{NA}. If
\code{NULL}, which is the default, no XML tag/attribute (depennding on the
\code{fields} argument) will be created for this dataframe element. Using a
non-\code{NULL} value for \code{non-exist} allows to make sure that each
data record tag in the XML document has exactly the same structure even if
some values may be empty (because they are \code{NA} in the original data)}

\item{encoding}{Encoding of the XML document; default is \code{"UTF-8"}}

\item{no.return}{Logical option to prevent \code{df_to_xml()} from returning
the XML document it creates; use this if you are only interested in saving
the XML document to a file using the \code{xml.file} argument.}
}
\value{
The resulting XML document that be edited with the functions from the
  \pkg{xml2} package. There is no return value if the \code{no.return}
  argument is set to \code{TRUE}.
}
\description{
Converts dataframes to XML documents.
}
\examples{
# Create a dataframe
soccer.worldcups <- data.frame(list(year=c(2014, 2010, 2006),
    location=c("Brazil", "South Africa", "Germany"),
    goals_scored=c(171, 145, 147),
    average_goals=c(2.7, 2.3, 2.4),
    average_attendance=c(57918, 49669,52491)),
    stringsAsFactors = FALSE)

# Convert to XML with the fields (i.e. dataframe variables/columns) stored in XML tags
xml <- df_to_xml(soccer.worldcups, fields="tags", record.tag = "worldcup")

# Convert to XML with the fields (i.e. dataframe variables/columns) stored in attributes
xml <- df_to_xml(soccer.worldcups, fields="tags", record.tag = "worldcup")

}
\seealso{
Other xmlconvert: 
\code{\link{xml_to_df}()}
}
\concept{xmlconvert}
