% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind.R
\name{c.xts}
\alias{c.xts}
\alias{rbind.xts}
\title{Concatenate Two or More xts Objects by Row}
\usage{
\method{c}{xts}(...)

\method{rbind}{xts}(..., deparse.level = 1)
}
\arguments{
\item{\dots}{Objects to bind by row.}

\item{deparse.level}{Not implemented.}
}
\value{
An xts object with one row per row for each object concatenated.
}
\description{
Concatenate or bind by row two or more xts objects along a time-based index.
All objects must have the same number of columns and be xts objects or
coercible to xts.
}
\details{
Duplicate index values are supported. When one or more input has the same
index value, the duplicated index values in the result are in the same order
the objects are passed to \code{rbind()}. See examples.

\code{c()} is an alias for \code{rbind()} for xts objects.

See \code{\link[=merge.xts]{merge.xts()}} for traditional merge operations.
}
\note{
\code{rbind()} is a '.Primitive' function in \R, which means method dispatch
occurs at the C-level, and may not be consistent with normal S3 method
dispatch (see \code{\link[=rbind]{rbind()}} for details). Call \code{rbind.xts()} directly to
avoid potential dispatch ambiguity.
}
\examples{

x <- xts(1:10, Sys.Date()+1:10)
str(x)

merge(x,x)
rbind(x,x)
rbind(x[1:5],x[6:10])

c(x,x)

# this also works on non-unique index values
x <- xts(rep(1,5), Sys.Date()+c(1,2,2,2,3))
y <- xts(rep(2,3), Sys.Date()+c(1,2,3))

# overlapping indexes are appended
rbind(x,y)
rbind(y,x)

}
\seealso{
\code{\link[=merge.xts]{merge.xts()}} \code{\link[=rbind]{rbind()}}
}
\author{
Jeffrey A. Ryan
}
\keyword{utilities}
