% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot.R
\name{ggplot.decorated}
\alias{ggplot.decorated}
\title{Create a New ggplot for a Decorated Data Frame}
\usage{
\method{ggplot}{decorated}(data, ...)
}
\arguments{
\item{data}{decorated, see \code{\link{decorate}}}

\item{...}{passed to \code{\link[ggplot2]{ggplot}}}
}
\value{
return value like \code{\link[ggplot2]{ggplot}} but inheriting 'decorated_ggplot'
}
\description{
Creates a new ggplot object for a decorated data.frame.
This is the ggplot() method for class 'decorated'.
It creates a ggplot object using the default method,
but reclassifies it as 'decorated_ggplot' so that a custom print method
is invoked; see \code{\link{print.decorated_ggplot}}.
}
\details{
This approach is similar to but more flexible than
the method for \code{\link{ggready}}.
For fine control, you can switch between 'data.frame'
and 'decorated' using \code{\link{as_decorated}}
(supplies null decorations) and \code{\link{as.data.frame}}
(preserves decorations).
}
\examples{
file <- system.file(package = 'yamlet', 'extdata','quinidine.csv')
library(ggplot2)
library(dplyr)
library(magrittr)
# par(ask = FALSE)

x <- decorate(file)
x \%<>\% filter(!is.na(conc))

# Manipulate class to switch among ggplot methods.
class(x)
class(data.frame(x))
class(as_decorated(data.frame(x)))

# The bare data.frame gives boring labels and un-ordered groups.
# (After ggplot2 v. 3.5.1 label attributes are honored as axis labels.)
map <- aes(x = time, y = conc, color = Heart)
data.frame(x) \%>\% ggplot(map) + geom_point()

# Decorated data.frame uses supplied labels.
# Notice CHF levels are still not ordered. (Moderate first.)
x \%>\% ggplot(map) + geom_point()

# If we resolve Heart, CHF levels are ordered.
x \%>\% resolve(Heart) \%>\% ggplot(map) + geom_point()

# We can map aesthetics as decorations.
x \%>\% 
  decorate('Heart: [ color: [gold, purple, green]]') \%>\%
  ggplot(map) + geom_point()

# Colors are matched to particular levels. Purple drops out here:
x \%>\% 
  decorate('Heart: [ color: [gold, purple, green]]') \%>\%
  filter(Heart != 'Moderate') \%>\%
  ggplot(map) + geom_point()

# We can resolve other columns for a chance to enrich the output with units.
x \%>\%
  resolve \%>\%
  ggplot(map) + geom_point()

# Underscore and circumflex imply subscript and superscript:
x \%>\% 
  redecorate("conc: [ conc_serum, mg*L^-1 ]") \%>\%
  ggplot(map) + geom_point()

# If we invoke enscript(), the subscripts and superscripts are rendered: 
x \%>\% 
  redecorate("conc: [ conc_serum, mg*L^-1 ]") \%>\%
  redecorate("Heart: [ CHF^\\\\* ]") \%>\%
  enscript \%>\%
  ggplot(map) + geom_point()

# Here we try a dataset with conditional labels and units.

file <- system.file(package = 'yamlet', 'extdata','phenobarb.csv')
x <- file \%>\% decorate \%>\% resolve
# Note that value has two elements for label, etc.
x \%>\% decorations(value)

# The print method defaults to the first, with warning.
map <- aes(x = time, y = value, color = event)
\donttest{
x \%>\% ggplot(map) + geom_point()
}

# If we subset appropriately, the relevant value is substituted.
x \%>\% filter(event == 'conc') \%>\% ggplot(map) + geom_point()

x \%>\% filter(event == 'conc') \%>\%
ggplot(aes(x = time, y = value, color = ApgarInd)) + geom_point()

x \%>\% filter(event == 'dose') \%>\%
ggplot(aes(x = time, y = value, color = Wt)) +
geom_point() +
scale_y_log10() +
scale_color_gradientn(colours = rainbow(4))

# print.decorated_ggplot will attempt to honor coordinated aesthetics.
x <- data.frame(x = c(1:6, 3:8), y = c(1:6,1:6), z = letters[c(1:6,1:6)])
x \%<>\% decorate('z: [color: ["red", "blue", "green", "gold", "black", "magenta"]]')
x \%<>\% decorate('z: [fill: ["red", "blue", "green", "gold", "black", "magenta"]]')
x \%<>\% decorate('z: [shape: [20, 21, 22, 23, 24, 25]]')
x \%<>\% decorate('z: [linetype: [6, 5, 4, 3, 2, 1]]')
x \%<>\% decorate('z: [alpha: [ .9, .8, .7, .6, .5, .4]]')
x \%<>\% decorate('z: [size: [1, 1.5, 2, 2.5, 3, 3.5]]')
x \%>\% ggplot(aes(
 x, y,
  color = z,
  fill = z,
  shape = z,
  linetype = z, 
  alpha = z,
  size = z,
)) + 
  geom_point() +
  geom_line(size = 1)
}
\seealso{
decorate resolve ggready

Other decorated_ggplot: 
\code{\link{ggplot_build.decorated_ggplot}()},
\code{\link{print.decorated_ggplot}()}

Other interface: 
\code{\link{canonical.decorated}()},
\code{\link{classified.data.frame}()},
\code{\link{decorate.character}()},
\code{\link{decorate.data.frame}()},
\code{\link{desolve.decorated}()},
\code{\link{enscript.default}()},
\code{\link{io_csv.character}()},
\code{\link{io_csv.data.frame}()},
\code{\link{io_res.character}()},
\code{\link{io_res.decorated}()},
\code{\link{io_table.character}()},
\code{\link{io_table.data.frame}()},
\code{\link{io_yamlet.character}()},
\code{\link{io_yamlet.data.frame}()},
\code{\link{is_parseable.default}()},
\code{\link{mimic.default}()},
\code{\link{modify.default}()},
\code{\link{promote.list}()},
\code{\link{read_yamlet}()},
\code{\link{resolve.decorated}()},
\code{\link{selected.default}()},
\code{\link{write_yamlet}()}
}
\concept{decorated_ggplot}
\concept{interface}
