% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/features.R
\name{z22_features}
\alias{z22_features}
\title{Features}
\usage{
z22_features(theme = NULL, year = NULL, res = NULL, legacy_names = FALSE)
}
\arguments{
\item{theme}{Theme of the feature. Available themes are \code{"population"},
\code{"families"}, \code{"households"}, \code{"dwellings"}, and
\code{"buildings"}. If \code{NULL}, returns features for all themes.}

\item{year}{Census year. Can be 2011 or 2022. If \code{NULL}, returns
features for both years.}

\item{res}{Resolution of the feature grid. Can be \code{"100m"},
\code{"1km"}, or \code{"10km"}. For Census 2011, only 100m and 1km are
available and not all features are available for both resolutions. For
Census 2022, all features are available at all resolutions. If
\code{NULL}, returns features for all resolutions.}

\item{legacy_names}{If \code{TRUE}, uses legacy (german) feature names from
the Census 2011 where possible. Defaults to \code{FALSE}.}
}
\value{
A tibble containing the following columns:

\itemize{
 \item{\code{theme}: Theme of the feature}
 \item{\code{feature}: Feature name}
 \item{\code{desc}: Human-readable english description}
 \item{\code{z22}: Whether the feature is available in the Census 2022}
 \item{\code{z11_100m}: Whether the feature is available in the Census 2011
 at a 100m resolution}
 \item{\code{z11_1km}: Whether the feature is available in the Census 2011
 at a 1km resolution}
 \item{\code{has_cat}: Whether the feature is is further divided into
 categories.}
}
}
\description{
Get a list of available features. To get a list of all categories, see
\code{\link{z22_categories}}.

For further clarification of terms used in the feature labels, see the
\link{glossary}.
}
\examples{
# return all features related to dwellings
z22_features("dwellings")

# return all features available in the Census 2011
z22_features(year = 2011)

# return all features available in 2011 at a 1km resolution
z22_features(year = 2011, res = "1km")
}
