% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zcurve_clustered.R
\name{zcurve_clustered}
\alias{zcurve_clustered}
\title{Fit a z-curve to clustered data}
\usage{
zcurve_clustered(
  data,
  method = "b",
  bootstrap = 1000,
  parallel = FALSE,
  control = NULL
)
}
\arguments{
\item{data}{an object created with \code{\link[=zcurve_data]{zcurve_data()}} function.}

\item{method}{the method to be used for fitting. Possible options are
down weighting \code{"w"} and nested bootstrap \code{"b"}.
Defaults to \code{"w"}.}

\item{bootstrap}{the number of bootstraps for estimating CI. To skip
bootstrap specify \code{FALSE}.}

\item{parallel}{whether the bootstrap should be performed in parallel.
Defaults to \code{FALSE}. The implementation is not completely stable
and might cause a connection error.}

\item{control}{additional options for the fitting algorithm more details in
\link[=control_EM]{control EM}.}
}
\value{
The fitted z-curve object
}
\description{
\code{zcurve_clustered} is used to fit z-curve models to
clustered data. The function requires a data object created with the
\code{\link[=zcurve_data]{zcurve_data()}} function as the input (where id denotes clusters).
Two different methods that account for clustering ar implemented via
the EM model: \code{"w"} for down weighting the likelihood of the test
statistics proportionately to the number of repetitions in the clusters,
and \code{"b"} for a nested bootstrap where only a single study from each
bootstrap is selected for model fitting.
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=zcurve]{zcurve()}}, \code{\link[=summary.zcurve]{summary.zcurve()}}, \code{\link[=plot.zcurve]{plot.zcurve()}}, \link{control_EM}, \link{control_density}
}
