% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete_mirror.R
\name{delete_mirror}
\alias{delete_mirror}
\title{Delete a deposit mirror}
\usage{
delete_mirror(deposit_id, cache_type = NULL, cache_dir = NULL)
}
\arguments{
\item{deposit_id}{numeric. The Zenodo deposit id.}

\item{cache_type}{character. Use \code{temporary} to a session temporary folder, \code{persistent} for a persistent cache folder or \code{NULL} to use the environment default. Check the section Cache Type for more details.}

\item{cache_dir}{character. User specified cache directory for persistent cache type.}
}
\value{
No return value. The function deletes mirrored on the system.
}
\description{
This function will delete all mirrored files stored locally.
}
\examples{
\dontshow{if (identical(tolower(Sys.getenv("NOT_CRAN")), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# https://zenodo.org/records/10959197
file_path <- zen_file(10959197, "iris.rds")
print(file_path)
file.exists(file_path)
delete_mirror(10959197)
file.exists(file_path)
\dontshow{\}) # examplesIf}
}
