/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.builtin;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public enum BuiltinScalarFunction {
    DIFF("diff"),
    CAST("cast"),
    ROUND("round"),
    REPLACE("replace"),
    SUBSTRING("substring");

    private final String functionName;
    private static final Set<String> NATIVE_FUNCTION_NAMES;
    public static final Set<String> DEVICE_VIEW_SPECIAL_PROCESS_FUNCTIONS;

    private BuiltinScalarFunction(String functionName) {
        this.functionName = functionName;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public static boolean contains(String functionName) {
        return NATIVE_FUNCTION_NAMES.contains(functionName.toLowerCase());
    }

    public static Set<String> getNativeFunctionNames() {
        return NATIVE_FUNCTION_NAMES;
    }

    static {
        NATIVE_FUNCTION_NAMES = new HashSet<String>(Arrays.stream(BuiltinScalarFunction.values()).map(BuiltinScalarFunction::getFunctionName).collect(Collectors.toList()));
        DEVICE_VIEW_SPECIAL_PROCESS_FUNCTIONS = ImmutableSet.of((Object)"diff");
    }
}

