/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.auth.user;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.commons.auth.entity.PathPrivilege;
import org.apache.iotdb.commons.auth.entity.Role;
import org.apache.iotdb.commons.auth.entity.User;
import org.apache.iotdb.commons.auth.role.LocalFileRoleAccessor;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.commons.utils.IOUtils;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileUserAccessor
extends LocalFileRoleAccessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalFileUserAccessor.class);
    public static final String ROLE_SUFFIX = "_role";

    public LocalFileUserAccessor(String userDirPath) {
        super(userDirPath);
    }

    @Override
    protected String getEntitySnapshotFileName() {
        return "system" + File.separator + "users";
    }

    @Override
    protected void saveEntityName(BufferedOutputStream outputStream, Role role) throws IOException {
        super.saveEntityName(outputStream, role);
        IOUtils.writeString(outputStream, ((User)role).getPassword(), "utf-8", this.encodingBufferLocal);
    }

    @Override
    protected void saveRoles(Role role) throws IOException {
        User user = (User)role;
        File roleProfile = SystemFileFactory.INSTANCE.getFile(this.entityDirPath + File.separator + user.getName() + ROLE_SUFFIX + ".profile" + ".temp");
        try (FileOutputStream fileOutputStream = new FileOutputStream(roleProfile);
             BufferedOutputStream outputStream = new BufferedOutputStream(fileOutputStream);){
            for (String roleName : user.getRoleSet()) {
                IOUtils.writeString(outputStream, roleName, "utf-8", this.encodingBufferLocal);
            }
            outputStream.flush();
            fileOutputStream.getFD().sync();
        }
        catch (Exception e) {
            LOGGER.warn("Get Exception when save user {}'s roles", (Object)user.getName(), (Object)e);
            throw new IOException(e);
        }
        finally {
            this.encodingBufferLocal.remove();
        }
        File oldURoleFile = SystemFileFactory.INSTANCE.getFile(this.entityDirPath + File.separator + user.getName() + ROLE_SUFFIX + ".profile");
        IOUtils.replaceFile(roleProfile, oldURoleFile);
    }

    @Override
    public User loadEntity(String entityName) throws IOException {
        File entityFile = this.checkFileAvailable(entityName, "");
        if (entityFile == null) {
            return null;
        }
        FileInputStream inputStream = new FileInputStream(entityFile);
        try {
            User user;
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
            try {
                boolean fromOldVersion = false;
                int tag = dataInputStream.readInt();
                if (tag < 0) {
                    fromOldVersion = true;
                }
                User user2 = new User();
                if (fromOldVersion) {
                    String name = IOUtils.readString(dataInputStream, "utf-8", this.strBufferLocal, -1 * tag);
                    user2.setName(name);
                    user2.setPassword(IOUtils.readString(dataInputStream, "utf-8", this.strBufferLocal));
                    user2.setSysPrivilegesWithMask(dataInputStream.readInt());
                    ArrayList<PathPrivilege> pathPrivilegeList = new ArrayList<PathPrivilege>();
                    int i = 0;
                    while (dataInputStream.available() != 0) {
                        pathPrivilegeList.add(IOUtils.readPathPrivilege(dataInputStream, "utf-8", this.strBufferLocal));
                        ++i;
                    }
                    user2.setPrivilegeList(pathPrivilegeList);
                } else {
                    assert (tag == 1);
                    user2.setName(IOUtils.readString(dataInputStream, "utf-8", this.strBufferLocal));
                    user2.setPassword(IOUtils.readString(dataInputStream, "utf-8", this.strBufferLocal));
                    this.loadPrivileges(dataInputStream, user2);
                }
                File roleOfUser = this.checkFileAvailable(entityName, ROLE_SUFFIX);
                HashSet<String> roleSet = new HashSet<String>();
                if (roleOfUser != null && roleOfUser.exists()) {
                    inputStream = new FileInputStream(roleOfUser);
                    try (DataInputStream roleInputStream = new DataInputStream(new BufferedInputStream(inputStream));){
                        int i = 0;
                        while (roleInputStream.available() != 0) {
                            String roleName = IOUtils.readString(roleInputStream, "utf-8", this.strBufferLocal);
                            roleSet.add(roleName);
                            ++i;
                        }
                    }
                }
                user2.setRoleSet(roleSet);
                user = user2;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        dataInputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            dataInputStream.close();
            return user;
        }
        finally {
            this.strBufferLocal.remove();
        }
    }

    @Override
    public boolean deleteEntity(String entityName) throws IOException {
        return super.deleteEntity(entityName) && this.deleteURole(entityName);
    }

    private boolean deleteURole(String username) throws IOException {
        File uRoleProfile = SystemFileFactory.INSTANCE.getFile(this.entityDirPath + File.separator + username + ROLE_SUFFIX + ".profile");
        File backProfile = SystemFileFactory.INSTANCE.getFile(this.entityDirPath + File.separator + username + ROLE_SUFFIX + ".profile" + ".temp");
        if (!uRoleProfile.exists() && !backProfile.exists()) {
            return true;
        }
        if (uRoleProfile.exists() && !uRoleProfile.delete() || backProfile.exists() && !backProfile.delete()) {
            throw new IOException(String.format("Catch error when delete %s 's role", username));
        }
        return true;
    }

    @Override
    public List<String> listAllEntities() {
        File userDir = SystemFileFactory.INSTANCE.getFile(this.entityDirPath);
        String[] names = userDir.list((dir, name) -> name.endsWith(".profile") && !name.endsWith("_role.profile") || name.endsWith(".temp") && !name.endsWith("_role.profile.temp"));
        return LocalFileUserAccessor.getEntityStrings(names);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processLoadSnapshot(File snapshotDir) throws TException, IOException {
        SystemFileFactory systemFileFactory = SystemFileFactory.INSTANCE;
        File userFolder = systemFileFactory.getFile(this.entityDirPath);
        File userTmpFolder = systemFileFactory.getFile(userFolder.getAbsolutePath() + "-" + UUID.randomUUID());
        File userSnapshotDir = systemFileFactory.getFile(snapshotDir, this.getEntitySnapshotFileName());
        try {
            FileUtils.moveDirectory((File)userFolder, (File)userTmpFolder);
            if (!org.apache.iotdb.commons.utils.FileUtils.copyDir(userSnapshotDir, userFolder)) {
                LOGGER.error("Failed to load user folder snapshot and rollback.");
                org.apache.iotdb.commons.utils.FileUtils.deleteFileOrDirectory(userFolder);
                FileUtils.moveDirectory((File)userTmpFolder, (File)userFolder);
            }
        }
        finally {
            org.apache.iotdb.commons.utils.FileUtils.deleteFileOrDirectory(userTmpFolder);
        }
    }

    @TestOnly
    public void saveUserOldVersion(User user) throws IOException {
        File userProfile = SystemFileFactory.INSTANCE.getFile(this.entityDirPath + File.separator + user.getName() + ".profile" + ".temp");
        try (FileOutputStream fileOutputStream = new FileOutputStream(userProfile);
             BufferedOutputStream outputStream = new BufferedOutputStream(fileOutputStream);){
            byte[] strBuffer = user.getName().getBytes("utf-8");
            IOUtils.writeInt(outputStream, -1 * strBuffer.length, this.encodingBufferLocal);
            outputStream.write(strBuffer);
            IOUtils.writeString(outputStream, user.getPassword(), "utf-8", this.encodingBufferLocal);
            IOUtils.writeInt(outputStream, user.getAllSysPrivileges(), this.encodingBufferLocal);
            int privilegeNum = user.getPathPrivilegeList().size();
            for (int i = 0; i < privilegeNum; ++i) {
                PathPrivilege pathPrivilege = user.getPathPrivilegeList().get(i);
                IOUtils.writePathPrivilege(outputStream, pathPrivilege, "utf-8", this.encodingBufferLocal);
            }
            outputStream.flush();
            fileOutputStream.getFD().sync();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            this.encodingBufferLocal.remove();
        }
        File oldFile = SystemFileFactory.INSTANCE.getFile(this.entityDirPath + File.separator + user.getName() + ".profile");
        IOUtils.replaceFile(userProfile, oldFile);
    }
}

