/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import serp.bytecode.Code;
import serp.bytecode.Instruction;
import serp.bytecode.TypedInstruction;
import serp.bytecode.visitor.BCVisitor;

public class MathInstruction
extends TypedInstruction {
    private static final Class[][] _mappings = new Class[][]{{Byte.TYPE, Integer.TYPE}, {Boolean.TYPE, Integer.TYPE}, {Character.TYPE, Integer.TYPE}, {Short.TYPE, Integer.TYPE}, {Void.TYPE, Integer.TYPE}, {Object.class, Integer.TYPE}};
    private int _op = -1;
    private String _type = null;

    MathInstruction(Code owner) {
        super(owner);
    }

    MathInstruction(Code owner, int opcode) {
        super(owner, opcode);
        this._op = this.getOperation();
    }

    @Override
    public int getStackChange() {
        int op = this.getOperation();
        if (op == 116 || this.getOpcode() == 0) {
            return 0;
        }
        String type = this.getTypeName();
        if (Long.TYPE.getName().equals(type) || Double.TYPE.getName().equals(type)) {
            switch (this.getOpcode()) {
                case 121: 
                case 123: 
                case 125: {
                    return -1;
                }
            }
            return -2;
        }
        return -1;
    }

    @Override
    public int getLogicalStackChange() {
        int op = this.getOperation();
        if (op == 116 || this.getOpcode() == 0) {
            return 0;
        }
        return -1;
    }

    @Override
    public String getTypeName() {
        switch (this.getOpcode()) {
            case 96: 
            case 100: 
            case 104: 
            case 108: 
            case 112: 
            case 116: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: {
                return Integer.TYPE.getName();
            }
            case 97: 
            case 101: 
            case 105: 
            case 109: 
            case 113: 
            case 117: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 131: {
                return Long.TYPE.getName();
            }
            case 98: 
            case 102: 
            case 106: 
            case 110: 
            case 114: 
            case 118: {
                return Float.TYPE.getName();
            }
            case 99: 
            case 103: 
            case 107: 
            case 111: 
            case 115: 
            case 119: {
                return Double.TYPE.getName();
            }
        }
        return this._type;
    }

    @Override
    public TypedInstruction setType(String type) {
        if ((type = this.mapType(type, _mappings, true)) == null || this._op < 0) {
            this._type = type;
            return (TypedInstruction)this.setOpcode(0);
        }
        this._type = null;
        switch (type.charAt(0)) {
            case 'i': {
                return (TypedInstruction)this.setOpcode(this._op);
            }
            case 'l': {
                return (TypedInstruction)this.setOpcode(this._op + 1);
            }
            case 'f': {
                return (TypedInstruction)this.setOpcode(this._op + 2);
            }
            case 'd': {
                return (TypedInstruction)this.setOpcode(this._op + 3);
            }
        }
        throw new IllegalStateException();
    }

    public MathInstruction setOperation(int operation) {
        this._op = operation;
        this.setType(this.getTypeName());
        return this;
    }

    public int getOperation() {
        switch (this.getOpcode()) {
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                return 96;
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                return 100;
            }
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                return 104;
            }
            case 108: 
            case 109: 
            case 110: 
            case 111: {
                return 108;
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: {
                return 112;
            }
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                return 116;
            }
            case 120: 
            case 121: {
                return 120;
            }
            case 122: 
            case 123: {
                return 122;
            }
            case 124: 
            case 125: {
                return 124;
            }
            case 126: 
            case 127: {
                return 126;
            }
            case 128: 
            case 129: {
                return 128;
            }
            case 130: 
            case 131: {
                return 130;
            }
        }
        return this._op;
    }

    @Override
    public boolean equalsInstruction(Instruction other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MathInstruction)) {
            return false;
        }
        MathInstruction ins = (MathInstruction)other;
        int op = this.getOperation();
        int otherOp = ins.getOperation();
        boolean opEq = op == -1 || otherOp == -1 || op == otherOp;
        String type = this.getTypeName();
        String otherType = ins.getTypeName();
        boolean typeEq = type == null || otherType == null || type.equals(otherType);
        return opEq && typeEq;
    }

    @Override
    public void acceptVisit(BCVisitor visit) {
        visit.enterMathInstruction(this);
        visit.exitMathInstruction(this);
    }

    @Override
    void read(Instruction orig) {
        super.read(orig);
        MathInstruction ins = (MathInstruction)orig;
        this._type = ins._type;
        this._op = ins._op;
    }
}

