/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.repeated;

import io.protostuff.OutputEx;
import io.protostuff.ProtobufOutputEx;
import io.protostuff.SchemaWriter;
import io.protostuff.WireFormat;
import io.protostuff.compiler.model.Field;
import io.protostuff.compiler.model.FieldType;
import io.protostuff.runtime.FieldTypeUtils;
import java.io.IOException;
import java.util.Collection;
import org.apache.servicecomb.foundation.common.utils.ReflectUtils;
import org.apache.servicecomb.foundation.protobuf.internal.ProtoUtils;

public abstract class AbstractWriters<T> {
    protected final Field protoField;
    protected final int tag;
    protected final int tagSize;
    public SchemaWriter<T[]> arrayWriter;
    public SchemaWriter<Collection<T>> collectionWriter;
    public SchemaWriter<String[]> stringArrayWriter;
    public final Class<T[]> arrayClass;

    public AbstractWriters(Field protoField) {
        this(protoField, null);
    }

    public AbstractWriters(Field protoField, Class<T[]> arrayClass) {
        this.protoField = protoField;
        int wireType = ProtoUtils.isPacked(protoField) && protoField.isRepeated() ? 2 : FieldTypeUtils.convert((FieldType)protoField.getType()).wireType;
        this.tag = WireFormat.makeTag((int)protoField.getTag(), (int)wireType);
        this.tagSize = ProtobufOutputEx.computeRawVarint32Size(this.tag);
        if (arrayClass == null) {
            arrayClass = ReflectUtils.getFieldArgument(this.getClass(), (String)"arrayWriter");
        }
        this.arrayClass = arrayClass;
    }

    public void dynamicWriteTo(OutputEx output, Object value) throws IOException {
        if (value instanceof Collection) {
            this.collectionWriter.writeTo(output, (Collection)value);
            return;
        }
        if (this.arrayClass.isInstance(value)) {
            this.arrayWriter.writeTo(output, (Object[])value);
            return;
        }
        if (value instanceof String[]) {
            this.stringArrayWriter.writeTo(output, (String[])value);
            return;
        }
        ProtoUtils.throwNotSupportWrite(this.protoField, value);
    }
}

