/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram.parfor;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.mapred.lib.NLineInputFormat;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.conf.DMLConfig;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.LocalVariableMap;
import org.apache.sysml.runtime.controlprogram.caching.CacheStatistics;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.parfor.RemoteParForColocatedNLineInputFormat;
import org.apache.sysml.runtime.controlprogram.parfor.RemoteParForJobReturn;
import org.apache.sysml.runtime.controlprogram.parfor.RemoteParWorkerMapper;
import org.apache.sysml.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysml.runtime.controlprogram.parfor.stat.Stat;
import org.apache.sysml.runtime.instructions.cp.Data;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.mapred.MRConfigurationNames;
import org.apache.sysml.runtime.matrix.mapred.MRJobConfiguration;
import org.apache.sysml.runtime.util.MapReduceTool;
import org.apache.sysml.runtime.util.ProgramConverter;
import org.apache.sysml.utils.Statistics;
import org.apache.sysml.yarn.DMLAppMasterUtils;

public class RemoteParForMR {
    protected static final Log LOG = LogFactory.getLog((String)RemoteParForMR.class.getName());

    public static RemoteParForJobReturn runJob(long pfid, String program, String taskFile, String resultFile, MatrixObject colocatedDPMatrixObj, boolean enableCPCaching, int numMappers, int replication, int max_retry, long minMem, boolean jvmReuse) {
        RemoteParForJobReturn ret = null;
        String jobname = "ParFor-EMR";
        long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        JobConf job = new JobConf(RemoteParForMR.class);
        job.setJobName(jobname + pfid);
        Statistics.incrementNoOfCompiledMRJobs();
        try {
            MRJobConfiguration.setProgramBlocks(job, program);
            MRJobConfiguration.setParforCachingConfig(job, enableCPCaching);
            job.setMapperClass(RemoteParWorkerMapper.class);
            if (colocatedDPMatrixObj != null) {
                job.setInputFormat(RemoteParForColocatedNLineInputFormat.class);
                MRJobConfiguration.setPartitioningFormat(job, colocatedDPMatrixObj.getPartitionFormat());
                MatrixCharacteristics mc = colocatedDPMatrixObj.getMatrixCharacteristics();
                MRJobConfiguration.setPartitioningBlockNumRows(job, mc.getRowsPerBlock());
                MRJobConfiguration.setPartitioningBlockNumCols(job, mc.getColsPerBlock());
                MRJobConfiguration.setPartitioningFilename(job, colocatedDPMatrixObj.getFileName());
            } else {
                job.setInputFormat(NLineInputFormat.class);
            }
            FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{new Path(taskFile)});
            job.setOutputFormat(SequenceFileOutputFormat.class);
            MapReduceTool.deleteFileIfExistOnHDFS(resultFile);
            FileOutputFormat.setOutputPath((JobConf)job, (Path)new Path(resultFile));
            job.setMapOutputKeyClass(LongWritable.class);
            job.setMapOutputValueClass(Text.class);
            job.setOutputKeyClass(LongWritable.class);
            job.setOutputValueClass(Text.class);
            job.setNumMapTasks(numMappers);
            job.setNumReduceTasks(0);
            String memKey = "mapred.child.java.opts";
            if (minMem > 0L && minMem > InfrastructureAnalyzer.extractMaxMemoryOpt(job.get(memKey))) {
                InfrastructureAnalyzer.setMaxMemoryOpt(job, memKey, minMem);
                LOG.warn((Object)("Forcing '" + memKey + "' to -Xmx" + minMem / 0x100000L + "M."));
            }
            job.setInt(MRConfigurationNames.MR_TASK_TIMEOUT, 0);
            job.setMapSpeculativeExecution(false);
            DMLConfig config = ConfigurationManager.getDMLConfig();
            DMLAppMasterUtils.setupMRJobRemoteMaxMemory(job, config);
            MRJobConfiguration.setupCustomMRConfigurations(job, config);
            if (jvmReuse) {
                job.setNumTasksToExecutePerJvm(-1);
            }
            job.setInt(MRConfigurationNames.MR_TASK_IO_SORT_MB, 8);
            job.setInt("dfs.replication", replication);
            MRJobConfiguration.setUniqueWorkingDir(job);
            RunningJob runjob = JobClient.runJob((JobConf)job);
            Statistics.incrementNoOfExecutedMRJobs();
            Counters.Group pgroup = runjob.getCounters().getGroup("SystemML ParFOR Counters");
            int numTasks = (int)pgroup.getCounter(Stat.PARFOR_NUMTASKS.toString());
            int numIters = (int)pgroup.getCounter(Stat.PARFOR_NUMITERS.toString());
            if (DMLScript.STATISTICS && !InfrastructureAnalyzer.isLocalMode()) {
                Statistics.incrementJITCompileTime(pgroup.getCounter(Stat.PARFOR_JITCOMPILE.toString()));
                Statistics.incrementJVMgcCount(pgroup.getCounter(Stat.PARFOR_JVMGC_COUNT.toString()));
                Statistics.incrementJVMgcTime(pgroup.getCounter(Stat.PARFOR_JVMGC_TIME.toString()));
                Counters.Group cgroup = runjob.getCounters().getGroup("SystemML Caching Counters".toString());
                CacheStatistics.incrementMemHits((int)cgroup.getCounter(CacheStatistics.Stat.CACHE_HITS_MEM.toString()));
                CacheStatistics.incrementFSBuffHits((int)cgroup.getCounter(CacheStatistics.Stat.CACHE_HITS_FSBUFF.toString()));
                CacheStatistics.incrementFSHits((int)cgroup.getCounter(CacheStatistics.Stat.CACHE_HITS_FS.toString()));
                CacheStatistics.incrementHDFSHits((int)cgroup.getCounter(CacheStatistics.Stat.CACHE_HITS_HDFS.toString()));
                CacheStatistics.incrementFSBuffWrites((int)cgroup.getCounter(CacheStatistics.Stat.CACHE_WRITES_FSBUFF.toString()));
                CacheStatistics.incrementFSWrites((int)cgroup.getCounter(CacheStatistics.Stat.CACHE_WRITES_FS.toString()));
                CacheStatistics.incrementHDFSWrites((int)cgroup.getCounter(CacheStatistics.Stat.CACHE_WRITES_HDFS.toString()));
                CacheStatistics.incrementAcquireRTime(cgroup.getCounter(CacheStatistics.Stat.CACHE_TIME_ACQR.toString()));
                CacheStatistics.incrementAcquireMTime(cgroup.getCounter(CacheStatistics.Stat.CACHE_TIME_ACQM.toString()));
                CacheStatistics.incrementReleaseTime(cgroup.getCounter(CacheStatistics.Stat.CACHE_TIME_RLS.toString()));
                CacheStatistics.incrementExportTime(cgroup.getCounter(CacheStatistics.Stat.CACHE_TIME_EXP.toString()));
            }
            LocalVariableMap[] results = RemoteParForMR.readResultFile(job, resultFile);
            ret = new RemoteParForJobReturn(runjob.isSuccessful(), numTasks, numIters, results);
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
        finally {
            try {
                MapReduceTool.deleteFileIfExistOnHDFS(new Path(taskFile), job);
                MapReduceTool.deleteFileIfExistOnHDFS(new Path(resultFile), job);
            }
            catch (IOException ex) {
                throw new DMLRuntimeException(ex);
            }
        }
        if (DMLScript.STATISTICS) {
            long t1 = System.nanoTime();
            Statistics.maintainCPHeavyHitters("MR-Job_" + jobname, t1 - t0);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LocalVariableMap[] readResultFile(JobConf job, String fname) throws IOException {
        HashMap<Long, LocalVariableMap> tmp = new HashMap<Long, LocalVariableMap>();
        Path path = new Path(fname);
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
        LongWritable key = new LongWritable();
        Text value = new Text();
        int countAll = 0;
        for (Path lpath : IOUtilFunctions.getSequenceFilePaths(fs, path)) {
            SequenceFile.Reader reader = new SequenceFile.Reader(fs, lpath, (Configuration)job);
            try {
                while (reader.next((Writable)key, (Writable)value)) {
                    if (!tmp.containsKey(key.get())) {
                        tmp.put(key.get(), new LocalVariableMap());
                    }
                    Object[] dat = ProgramConverter.parseDataObject(value.toString());
                    ((LocalVariableMap)tmp.get(key.get())).put((String)dat[0], (Data)dat[1]);
                    ++countAll;
                }
            }
            finally {
                IOUtilFunctions.closeSilently((Closeable)reader);
            }
        }
        LOG.debug((Object)("Num remote worker results (before deduplication): " + countAll));
        LOG.debug((Object)("Num remote worker results: " + tmp.size()));
        return tmp.values().toArray(new LocalVariableMap[0]);
    }
}

