/*
 * Decompiled with CFR 0.152.
 */
package jcuda.nvrtc;

import jcuda.CudaException;
import jcuda.LibUtils;
import jcuda.LogLevel;
import jcuda.nvrtc.nvrtcProgram;
import jcuda.nvrtc.nvrtcResult;
import jcuda.runtime.JCuda;

public class JNvrtc {
    private static boolean exceptionsEnabled = false;

    private JNvrtc() {
    }

    public static void setLogLevel(LogLevel logLevel) {
        JNvrtc.setLogLevel(logLevel.ordinal());
    }

    private static native void setLogLevel(int var0);

    public static void setExceptionsEnabled(boolean enabled) {
        exceptionsEnabled = enabled;
    }

    private static int checkResult(int result) {
        if (exceptionsEnabled && result != 0) {
            throw new CudaException(nvrtcResult.stringFor(result));
        }
        return result;
    }

    public static String nvrtcGetErrorString(int result) {
        return JNvrtc.nvrtcGetErrorStringNative(result);
    }

    private static native String nvrtcGetErrorStringNative(int var0);

    public static int nvrtcVersion(int[] major, int[] minor) {
        return JNvrtc.checkResult(JNvrtc.nvrtcVersionNative(major, minor));
    }

    private static native int nvrtcVersionNative(int[] var0, int[] var1);

    public static int nvrtcCreateProgram(nvrtcProgram prog, String src, String name, int numHeaders, String[] headers, String[] includeNames) {
        return JNvrtc.checkResult(JNvrtc.nvrtcCreateProgramNative(prog, src, name, numHeaders, headers, includeNames));
    }

    private static native int nvrtcCreateProgramNative(nvrtcProgram var0, String var1, String var2, int var3, String[] var4, String[] var5);

    public static int nvrtcDestroyProgram(nvrtcProgram prog) {
        return JNvrtc.checkResult(JNvrtc.nvrtcDestroyProgramNative(prog));
    }

    private static native int nvrtcDestroyProgramNative(nvrtcProgram var0);

    public static int nvrtcCompileProgram(nvrtcProgram prog, int numOptions, String[] options) {
        return JNvrtc.checkResult(JNvrtc.nvrtcCompileProgramNative(prog, numOptions, options));
    }

    private static native int nvrtcCompileProgramNative(nvrtcProgram var0, int var1, String[] var2);

    public static int nvrtcGetPTXSize(nvrtcProgram prog, long[] ptxSizeRet) {
        return JNvrtc.checkResult(JNvrtc.nvrtcGetPTXSizeNative(prog, ptxSizeRet));
    }

    private static native int nvrtcGetPTXSizeNative(nvrtcProgram var0, long[] var1);

    public static int nvrtcGetPTX(nvrtcProgram prog, String[] ptx) {
        return JNvrtc.checkResult(JNvrtc.nvrtcGetPTXNative(prog, ptx));
    }

    private static native int nvrtcGetPTXNative(nvrtcProgram var0, String[] var1);

    public static int nvrtcGetProgramLogSize(nvrtcProgram prog, long[] logSizeRet) {
        return JNvrtc.checkResult(JNvrtc.nvrtcGetProgramLogSizeNative(prog, logSizeRet));
    }

    private static native int nvrtcGetProgramLogSizeNative(nvrtcProgram var0, long[] var1);

    public static int nvrtcGetProgramLog(nvrtcProgram prog, String[] log) {
        return JNvrtc.checkResult(JNvrtc.nvrtcGetProgramLogNative(prog, log));
    }

    private static native int nvrtcGetProgramLogNative(nvrtcProgram var0, String[] var1);

    public static int nvrtcAddNameExpression(nvrtcProgram prog, String name_expression) {
        return JNvrtc.checkResult(JNvrtc.nvrtcAddNameExpressionNative(prog, name_expression));
    }

    private static native int nvrtcAddNameExpressionNative(nvrtcProgram var0, String var1);

    public static int nvrtcGetLoweredName(nvrtcProgram prog, String name_expression, String[] lowered_name) {
        return JNvrtc.checkResult(JNvrtc.nvrtcGetLoweredNameNative(prog, name_expression, lowered_name));
    }

    private static native int nvrtcGetLoweredNameNative(nvrtcProgram var0, String var1, String[] var2);

    static {
        String libraryBaseName = "JNvrtc-" + JCuda.getJCudaVersion();
        String libraryName = LibUtils.createPlatformLibraryName(libraryBaseName);
        LibUtils.loadLibrary(libraryName, new String[0]);
    }
}

