/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.api.dl;

import caffe.Caffe;
import java.util.List;
import org.apache.sysml.api.dl.CaffeLayer;
import org.apache.sysml.api.dl.CaffeSolver;
import org.apache.sysml.runtime.DMLRuntimeException;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public abstract class CaffeSolver$class {
    private static String getLayerLr(CaffeSolver $this, CaffeLayer layer, int paramIndex) {
        List<Caffe.ParamSpec> param = layer.param().getParamList();
        if (param == null || param.size() <= paramIndex) {
            return "lr";
        }
        return new StringBuilder().append((Object)"(lr * ").append((Object)BoxesRunTime.boxToFloat((float)param.get(paramIndex).getLrMult())).append((Object)")").toString();
    }

    public static String getWeightLr(CaffeSolver $this, CaffeLayer layer) {
        return CaffeSolver$class.getLayerLr($this, layer, 0);
    }

    public static String getBiasLr(CaffeSolver $this, CaffeLayer layer) {
        return CaffeSolver$class.getLayerLr($this, layer, 1);
    }

    public static String commaSep(CaffeSolver $this, Seq arr) {
        String string;
        if (arr.length() == 1) {
            string = (String)arr.apply(0);
        } else {
            ObjectRef ret = ObjectRef.create((Object)((String)arr.apply(0)));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), arr.length()).foreach$mVc$sp((Function1)new Serializable($this, ret, arr){
                public static final long serialVersionUID = 0L;
                private final ObjectRef ret$1;
                private final Seq arr$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    this.ret$1.elem = new StringBuilder().append((Object)((String)this.ret$1.elem)).append((Object)",").append(this.arr$1.apply(i)).toString();
                }
                {
                    this.ret$1 = ret$1;
                    this.arr$1 = arr$1;
                }
            });
            string = (String)ret.elem;
        }
        return string;
    }

    public static void regularization_update(CaffeSolver $this, String regularizationType, double lambda, StringBuilder dmlScript, CaffeLayer layer) {
        String regularizationSource;
        String string = regularizationType.toLowerCase().equals("l2") ? "l2_reg" : (regularizationSource = regularizationType.toLowerCase().equals("l1") ? "l1_reg" : null);
        if (regularizationSource == null) {
            throw new DMLRuntimeException(new StringBuilder().append((Object)"Unsupported regularization_type:").append((Object)regularizationType).append((Object)". Please use either L2 or L1.").toString());
        }
        if (lambda != 0.0 && layer.shouldUpdateWeight()) {
            boolean hasDecayMult = layer.param().getParamList() != null && layer.param().getParamList().size() >= 1 && layer.param().getParamList().get(0).hasDecayMult();
            double newLambda = hasDecayMult ? (double)layer.param().getParamList().get(0).getDecayMult() * lambda : lambda;
            dmlScript.append("\t").append(new StringBuilder().append((Object)layer.dWeight()).append((Object)"_reg = ").append((Object)regularizationSource).append((Object)"::backward(").append((Object)layer.weight()).append((Object)", ").append((Object)BoxesRunTime.boxToDouble((double)newLambda)).append((Object)")\n").toString());
            dmlScript.append("\t").append(new StringBuilder().append((Object)layer.dWeight()).append((Object)" = ").append((Object)layer.dWeight()).append((Object)" + ").append((Object)layer.dWeight()).append((Object)"_reg\n").toString());
            if (layer.shouldUpdateExtraWeight()) {
                dmlScript.append("\t").append(new StringBuilder().append((Object)layer.dExtraWeight()).append((Object)"_reg = ").append((Object)regularizationSource).append((Object)"::backward(").append((Object)layer.extraWeight()).append((Object)", ").append((Object)BoxesRunTime.boxToDouble((double)newLambda)).append((Object)")\n").toString());
                dmlScript.append("\t").append(new StringBuilder().append((Object)layer.dExtraWeight()).append((Object)" = ").append((Object)layer.dExtraWeight()).append((Object)" + ").append((Object)layer.dExtraWeight()).append((Object)"_reg\n").toString());
            }
        }
    }

    public static void $init$(CaffeSolver $this) {
    }
}

