/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import java.util.List;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.cli.TemplateUtil;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.ui.CodewindUIPlugin;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.codewind.ui.internal.prefs.RepositoryManagementDialog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionProviderAction;

public class ManageReposAction
extends SelectionProviderAction {
    protected CodewindConnection connection;

    public ManageReposAction(ISelectionProvider selectionProvider) {
        super(selectionProvider, Messages.RepoMgmtActionLabel);
        this.setImageDescriptor(CodewindUIPlugin.getDefaultIcon());
        this.selectionChanged(this.getStructuredSelection());
    }

    public void selectionChanged(IStructuredSelection sel) {
        Object obj;
        if (sel.size() == 1 && (obj = sel.getFirstElement()) instanceof CodewindConnection) {
            this.connection = (CodewindConnection)obj;
            this.setEnabled(this.connection.isConnected());
            return;
        }
        this.setEnabled(false);
    }

    public void run() {
        if (this.connection == null) {
            Logger.logError((String)"ManageReposAction ran but no Codewind connection was selected");
            return;
        }
        try {
            List repoList = TemplateUtil.listTemplateSources((String)this.connection.getConid(), (IProgressMonitor)new NullProgressMonitor());
            final RepositoryManagementDialog repoDialog = new RepositoryManagementDialog(Display.getDefault().getActiveShell(), this.connection, repoList);
            if (repoDialog.open() == 0 && repoDialog.hasChanges()) {
                Job job = new Job(Messages.RepoUpdateTask){

                    protected IStatus run(IProgressMonitor monitor) {
                        return repoDialog.updateRepos(monitor);
                    }
                };
                job.schedule();
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.RepoListErrorTitle, (String)NLS.bind((String)Messages.RepoListErrorMsg, (Object)e));
        }
    }
}

