/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.debug;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.internal.browser.BrowserManager;
import org.eclipse.ui.internal.browser.IBrowserDescriptor;

public class WebBrowserSelectionDialog
extends MessageDialog {
    protected Link manageBrowserButton;
    protected boolean isNodejsDefaultBrowser = false;
    protected String browserName = null;
    protected Combo webBrowserCombo;
    protected List<IBrowserDescriptor> validBrowsers;
    protected Button isNodejsDefaultBrowserBtn;

    public WebBrowserSelectionDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createCustomArea(Composite parent) {
        final Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)data);
        Text label = new Text(composite, 12);
        label.setText(Messages.BrowserSelectionListLabel);
        label.setBackground(composite.getBackground());
        label.setForeground(composite.getForeground());
        this.updateWebBrowserCombo(composite);
        this.manageBrowserButton = new Link(composite, 0);
        this.manageBrowserButton.setText("<a>" + Messages.BrowserSelectionManageButtonText + "</a>");
        this.manageBrowserButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String id = "org.eclipse.ui.browser.preferencePage";
                String id2 = "org.eclipse.ui.browser.preferencePage";
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)WebBrowserSelectionDialog.this.getShell(), (String)id2, (String[])new String[]{id, id2}, null);
                if (dialog.open() == 0) {
                    WebBrowserSelectionDialog.this.updateWebBrowserCombo(composite);
                }
            }
        });
        Label curLabel = new Label(composite, 0);
        GridData data1 = new GridData(256);
        data1.horizontalSpan = 2;
        curLabel.setLayoutData((Object)data1);
        this.isNodejsDefaultBrowserBtn = new Button(composite, 32);
        this.isNodejsDefaultBrowserBtn.setText(Messages.BrowserSelectionAlwaysUseMsg);
        this.isNodejsDefaultBrowserBtn.setLayoutData((Object)data1);
        this.isNodejsDefaultBrowserBtn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (WebBrowserSelectionDialog.this.validBrowsers != null && WebBrowserSelectionDialog.this.validBrowsers.size() > 0) {
                    WebBrowserSelectionDialog.this.isNodejsDefaultBrowser = WebBrowserSelectionDialog.this.isNodejsDefaultBrowserBtn.getSelection();
                }
            }
        });
        return composite;
    }

    protected void updateWebBrowserCombo(Composite composite) {
        List browserList;
        if (this.webBrowserCombo == null) {
            this.webBrowserCombo = new Combo(composite, 2056);
        } else {
            this.webBrowserCombo.removeAll();
        }
        BrowserManager bm = BrowserManager.getInstance();
        if (bm != null && (browserList = bm.getWebBrowsers()) != null) {
            this.validBrowsers = new ArrayList<IBrowserDescriptor>();
            int len = browserList.size();
            for (int i = 0; i < len; ++i) {
                IBrowserDescriptor tempBrowser = (IBrowserDescriptor)browserList.get(i);
                if (tempBrowser == null || tempBrowser.getLocation() == null || tempBrowser.getLocation().trim().equals("")) continue;
                this.validBrowsers.add(tempBrowser);
            }
            len = this.validBrowsers.size();
            int selectedIndex = -1;
            for (int i = 0; i < len; ++i) {
                IBrowserDescriptor tempBrowser = this.validBrowsers.get(i);
                if (tempBrowser == null) continue;
                this.webBrowserCombo.add(tempBrowser.getName());
                String location = tempBrowser.getLocation();
                if (location == null || location.toLowerCase().indexOf("chrome") < 0) continue;
                selectedIndex = i;
            }
            Button okButton = this.getButton(0);
            if (okButton != null) {
                okButton.setEnabled(selectedIndex >= 0);
            }
            if (selectedIndex >= 0) {
                this.webBrowserCombo.select(selectedIndex);
                this.browserName = this.validBrowsers.get(selectedIndex).getName();
            }
            this.webBrowserCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Button okButton;
                    boolean valid = false;
                    if (WebBrowserSelectionDialog.this.validBrowsers != null && WebBrowserSelectionDialog.this.webBrowserCombo.getSelectionIndex() >= 0) {
                        WebBrowserSelectionDialog.this.browserName = WebBrowserSelectionDialog.this.validBrowsers.get(WebBrowserSelectionDialog.this.webBrowserCombo.getSelectionIndex()).getName();
                        valid = true;
                    }
                    if ((okButton = WebBrowserSelectionDialog.this.getButton(0)) != null) {
                        okButton.setEnabled(valid);
                    }
                }
            });
        }
        this.webBrowserCombo.setLayoutData((Object)new GridData(4, 4, true, false));
    }

    public boolean isNodejsDefaultBrowserSet() {
        return this.isNodejsDefaultBrowser;
    }

    public String getBrowserName() {
        return this.browserName;
    }

    public int open() {
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(this.webBrowserCombo != null && this.webBrowserCombo.getSelectionIndex() >= 0);
        }
        return super.open();
    }
}

