/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.wizards;

import java.util.List;
import org.eclipse.codewind.core.CodewindCorePlugin;
import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.CodewindManager;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.cli.ProjectUtil;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.connection.CodewindConnectionManager;
import org.eclipse.codewind.core.internal.connection.ProjectTemplateInfo;
import org.eclipse.codewind.ui.CodewindUIPlugin;
import org.eclipse.codewind.ui.internal.actions.CodewindInstall;
import org.eclipse.codewind.ui.internal.actions.ImportProjectAction;
import org.eclipse.codewind.ui.internal.actions.OpenAppOverviewAction;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.codewind.ui.internal.views.ViewHelper;
import org.eclipse.codewind.ui.internal.wizards.NewCodewindProjectPage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewCodewindProjectWizard
extends Wizard
implements INewWizard {
    private CodewindConnection connection = null;
    private List<ProjectTemplateInfo> templateList = null;
    private NewCodewindProjectPage newProjectPage = null;

    public NewCodewindProjectWizard() {
        this.setDefaultPageImageDescriptor(CodewindUIPlugin.getImageDescriptor("codewindBanner.png"));
        this.setHelpAvailable(false);
        this.setNeedsProgressMonitor(true);
    }

    public NewCodewindProjectWizard(CodewindConnection connection, List<ProjectTemplateInfo> templateList) {
        this();
        this.connection = connection;
        this.templateList = templateList;
    }

    public void init(IWorkbench arg0, IStructuredSelection arg1) {
    }

    public void addPages() {
        if (CodewindManager.getManager().getInstallerStatus() != null) {
            CodewindInstall.installerActiveDialog(CodewindManager.getManager().getInstallerStatus());
            if (this.getContainer() != null) {
                this.getContainer().getShell().close();
            }
        } else if (CodewindManager.getManager().getInstallStatus().isInstalled()) {
            this.setWindowTitle(Messages.NewProjectPage_ShellTitle);
            this.newProjectPage = new NewCodewindProjectPage(this.connection, this.templateList);
            this.addPage((IWizardPage)this.newProjectPage);
        } else {
            CodewindInstall.codewindInstallerDialog();
            if (this.getContainer() != null) {
                this.getContainer().getShell().close();
            }
        }
    }

    public boolean performCancel() {
        CodewindConnection newConnection;
        if (this.newProjectPage != null && (newConnection = this.newProjectPage.getConnection()) != null && CodewindConnectionManager.getActiveConnection((String)newConnection.getBaseURI().toString()) == null) {
            newConnection.close();
        }
        return super.performCancel();
    }

    public boolean performFinish() {
        if (!this.canFinish()) {
            return false;
        }
        final ProjectTemplateInfo info = this.newProjectPage.getProjectTemplateInfo();
        final String name = this.newProjectPage.getProjectName();
        final String location = this.newProjectPage.getLocation();
        final CodewindConnection newConnection = this.newProjectPage.getConnection();
        if (info == null || name == null || location == null || newConnection == null) {
            Logger.logError((String)"The connection, project type, name or location was null for the new project wizard");
            return false;
        }
        Job job = new Job(NLS.bind((String)Messages.NewProjectPage_CreateJobLabel, (Object)name)){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    Path localPath = new Path(location);
                    ProjectUtil.createProject((String)name, (String)localPath.toOSString(), (String)info.getUrl(), (IProgressMonitor)mon.split(40));
                    if (mon.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    newConnection.requestProjectBind(name, localPath.toOSString(), info.getLanguage(), info.getProjectType());
                    if (CodewindConnectionManager.getActiveConnection((String)newConnection.getBaseURI().toString()) == null) {
                        CodewindConnectionManager.add((CodewindConnection)newConnection);
                    }
                    if (mon.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    mon.worked(40);
                    newConnection.refreshApps(null);
                    if (mon.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    mon.worked(10);
                    CodewindApplication app = newConnection.getAppByName(name);
                    if (app != null) {
                        ImportProjectAction.importProject(app);
                        if (CodewindCorePlugin.getDefault().getPreferenceStore().getBoolean("autoOpenOverviewPage")) {
                            Display.getDefault().asyncExec(() -> OpenAppOverviewAction.openAppOverview(app));
                        }
                    } else {
                        Logger.logError((String)("Could not get the application for import: " + name));
                    }
                    mon.worked(10);
                    mon.done();
                    ViewHelper.openCodewindExplorerView();
                    ViewHelper.refreshCodewindExplorerView(newConnection);
                    ViewHelper.expandConnection(newConnection);
                    return Status.OK_STATUS;
                }
                catch (Exception e) {
                    Logger.logError((String)("An error occured trying to create a project with type: " + info.getUrl() + ", and name: " + name), (Throwable)e);
                    return new Status(4, "org.eclipse.codewind.ui", NLS.bind((String)Messages.NewProjectPage_ProjectCreateErrorMsg, (Object)name), (Throwable)e);
                }
            }
        };
        job.schedule();
        return true;
    }
}

