/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.regionaccess.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.formatting2.ITextSegment;
import org.eclipse.xtext.formatting2.internal.TextSegment;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.internal.AbstractEObjectTokens;
import org.eclipse.xtext.formatting2.regionaccess.internal.AbstractRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.internal.EObjectTokens;
import org.eclipse.xtext.formatting2.regionaccess.internal.HiddenRegion;
import org.eclipse.xtext.formatting2.regionaccess.internal.NodeComment;
import org.eclipse.xtext.formatting2.regionaccess.internal.NodeHidden;
import org.eclipse.xtext.formatting2.regionaccess.internal.NodeSemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.internal.NodeWhitespace;
import org.eclipse.xtext.nodemodel.BidiTreeIterator;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;

public class NodeModelBasedRegionAccess
extends AbstractRegionAccess {
    protected NodeModelBasedRegionAccess(Builder builder) {
        super(builder);
    }

    @Override
    public ITextSegment expandRegionsByLines(int leadingLines, int trailingLines, ITextSegment ... regions) {
        int offset = regions[0].getOffset();
        int endOffset = regions[0].getEndOffset();
        int i = 1;
        while (i < regions.length) {
            int e;
            ITextSegment region = regions[i];
            int o = region.getOffset();
            if (o < offset) {
                offset = o;
            }
            if ((e = region.getEndOffset()) > endOffset) {
                endOffset = e;
            }
            ++i;
        }
        String text = this.getText();
        int i2 = 0;
        while (i2 < leadingLines && offset >= 0) {
            offset = text.lastIndexOf("\n", offset) - 1;
            ++i2;
        }
        i2 = 0;
        while (i2 < trailingLines && endOffset <= text.length() && endOffset > 0) {
            endOffset = text.indexOf("\n", endOffset);
            ++i2;
        }
        if (offset < 0) {
            offset = 0;
        }
        if (endOffset < 0 || endOffset > text.length()) {
            endOffset = text.length();
        }
        return new TextSegment(this, offset, endOffset - offset);
    }

    protected EObject findSemanticElement(INode node) {
        EObject element = node.getGrammarElement();
        if (element instanceof Action) {
            return node.getSemanticElement();
        }
        if (GrammarUtil.isParserRuleCall(element)) {
            return this.findSemanticElementFromChildren(node);
        }
        ICompositeNode parent = node.getParent();
        if (parent == null) {
            BidiTreeIterator<INode> it = node.getAsTreeIterable().iterator();
            while (it.hasNext()) {
                EObject sem = it.next().getSemanticElement();
                if (sem == null) continue;
                return EcoreUtil.getRootContainer((EObject)sem);
            }
        }
        return this.findSemanticElement(parent);
    }

    protected EObject findSemanticElementFromChildren(INode node) {
        for (INode next : node.getAsTreeIterable()) {
            EObject semanticElement;
            EObject grammarElement = next.getGrammarElement();
            if (next == node || !(grammarElement instanceof RuleCall)) continue;
            if (GrammarUtil.isAssigned(grammarElement) && (semanticElement = next.getParent().getSemanticElement()) != null) {
                return semanticElement;
            }
            semanticElement = next.getSemanticElement();
            if (semanticElement == null) continue;
            return semanticElement;
        }
        return node.getParent().getSemanticElement();
    }

    public int getLength() {
        return this.getResource().getParseResult().getRootNode().getTotalEndOffset();
    }

    @Override
    public String getText() {
        return this.getResource().getParseResult().getRootNode().getText();
    }

    @Override
    public boolean hasSyntaxError() {
        return this.getResource().getParseResult().hasSyntaxErrors();
    }

    @Override
    public boolean hasSyntaxError(EObject object) {
        BidiTreeIterator<INode> it = NodeModelUtils.getNode(object).getAsTreeIterable().iterator();
        while (it.hasNext()) {
            if (it.next().getSyntaxErrorMessage() == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public ITextSegment indentationRegion(int offset) {
        int lineStart;
        String text = this.getText();
        int i = lineStart = text.lastIndexOf(10, offset) + 1;
        while (i < text.length()) {
            if (!Character.isWhitespace(text.charAt(i))) {
                return new TextSegment(this.getTextRegionAccess(), lineStart, i - lineStart);
            }
            ++i;
        }
        return null;
    }

    public static class Builder
    extends AbstractRegionAccess.Builder {
        private Map<EObject, EObjectTokens> eObjToTokens;
        private ISemanticRegion firstToken;
        private ITextSegment lastTokenOrGap;
        private EObjectTokens lastTokens;
        private XtextResource resource;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected boolean add(NodeModelBasedRegionAccess tokenAccess, INode node) {
            boolean result;
            EObject semanticElement = tokenAccess.findSemanticElement(node);
            if (this.lastTokens == null || semanticElement != this.lastTokens.getSemanticElement()) {
                this.lastTokens = this.eObjToTokens.get(semanticElement);
            }
            if (this.lastTokens == null) {
                this.lastTokens = this.createTokens(tokenAccess, node);
                this.eObjToTokens.put(semanticElement, this.lastTokens);
            }
            if (!(result = this.include(node))) return result;
            if (node instanceof ILeafNode && ((ILeafNode)node).isHidden()) {
                ILeafNode leafNode = (ILeafNode)node;
                if (this.lastTokenOrGap instanceof NodeSemanticRegion) {
                    NodeSemanticRegion lastToken = (NodeSemanticRegion)this.lastTokenOrGap;
                    HiddenRegion gap = this.createGap(tokenAccess);
                    lastToken.setTrailingGap(gap);
                    gap.setPrevious(lastToken);
                    gap.hiddens.add(this.createHidden(gap, leafNode));
                    this.lastTokenOrGap = gap;
                    return result;
                } else if (this.lastTokenOrGap instanceof HiddenRegion) {
                    HiddenRegion lastGap = (HiddenRegion)this.lastTokenOrGap;
                    lastGap.hiddens.add(this.createHidden(lastGap, leafNode));
                    return result;
                } else {
                    if (this.lastTokenOrGap != null) throw new IllegalStateException();
                    HiddenRegion gap = this.createGap(tokenAccess);
                    gap.hiddens.add(this.createHidden(gap, leafNode));
                    this.lastTokenOrGap = gap;
                }
                return result;
            } else {
                NodeSemanticRegion newToken = this.createToken(tokenAccess, node);
                if (this.lastTokenOrGap == null) {
                    this.lastTokenOrGap = this.createGap(tokenAccess);
                }
                if (this.lastTokenOrGap instanceof NodeSemanticRegion) {
                    NodeSemanticRegion lastToken = (NodeSemanticRegion)this.lastTokenOrGap;
                    HiddenRegion gap = this.createGap(tokenAccess);
                    lastToken.setTrailingGap(gap);
                    gap.setPrevious(lastToken);
                    newToken.setLeadingGap(gap);
                    gap.setNext(newToken);
                } else {
                    if (!(this.lastTokenOrGap instanceof HiddenRegion)) throw new IllegalStateException();
                    HiddenRegion lastGap = (HiddenRegion)this.lastTokenOrGap;
                    lastGap.setNext(newToken);
                    newToken.setLeadingGap(lastGap);
                }
                if (this.lastTokens != null) {
                    this.lastTokens.getTokens().add(newToken);
                }
                this.lastTokenOrGap = newToken;
                if (this.firstToken != null) return result;
                this.firstToken = newToken;
            }
            return result;
        }

        public NodeModelBasedRegionAccess create() {
            NodeModelBasedRegionAccess tokenAccess = new NodeModelBasedRegionAccess(this);
            return tokenAccess;
        }

        protected HiddenRegion createGap(ITextRegionAccess tokenAccess) {
            return new HiddenRegion(tokenAccess);
        }

        protected NodeHidden createHidden(HiddenRegion gap, ILeafNode node) {
            if (this.isComment(node)) {
                return new NodeComment(gap, (INode)node);
            }
            return new NodeWhitespace(gap, (INode)node);
        }

        protected NodeSemanticRegion createToken(NodeModelBasedRegionAccess tokenAccess, INode node) {
            return new NodeSemanticRegion(tokenAccess, node);
        }

        protected EObjectTokens createTokens(NodeModelBasedRegionAccess access, INode node) {
            return new EObjectTokens(access, node);
        }

        @Override
        protected Map<EObject, AbstractEObjectTokens> getEObjectToTokensMap(ITextRegionAccess tokenAccess) {
            this.eObjToTokens = Maps.newHashMap();
            this.lastTokenOrGap = null;
            this.lastTokens = null;
            this.firstToken = null;
            NodeModelBasedRegionAccess access = (NodeModelBasedRegionAccess)tokenAccess;
            ICompositeNode rootNode = this.resource.getParseResult().getRootNode();
            BidiTreeIterator<INode> iterator = rootNode.getAsTreeIterable().iterator();
            while (iterator.hasNext()) {
                INode next = (INode)iterator.next();
                if (next instanceof ICompositeNode && this.include(next)) {
                    for (INode next2 : next.getAsTreeIterable()) {
                        if (next2 == next || !(next2 instanceof ILeafNode)) continue;
                        if (!((ILeafNode)next2).isHidden()) break;
                        this.add(access, next2);
                    }
                }
                if (!this.add(access, next)) continue;
                iterator.prune();
            }
            if (this.lastTokenOrGap instanceof NodeSemanticRegion) {
                NodeSemanticRegion last = (NodeSemanticRegion)this.lastTokenOrGap;
                HiddenRegion gap = this.createGap(tokenAccess);
                last.setTrailingGap(gap);
                gap.setPrevious(last);
            }
            this.setLeadingGaps();
            this.setTrailingGaps();
            return ImmutableMap.copyOf(this.eObjToTokens);
        }

        @Override
        protected IHiddenRegion getFirstRegion() {
            return this.firstToken.getNextHiddenRegion();
        }

        @Override
        protected XtextResource getXtextResource() {
            return this.resource;
        }

        protected boolean include(INode node) {
            if (node instanceof ILeafNode) {
                return true;
            }
            if (node instanceof ICompositeNode) {
                EObject element = node.getGrammarElement();
                return GrammarUtil.isDatatypeRuleCall(element) || element instanceof CrossReference || GrammarUtil.isEnumRuleCall(element);
            }
            return false;
        }

        protected boolean isComment(ILeafNode leaf) {
            String text = leaf.getText();
            int i = 0;
            while (i < text.length()) {
                if (!Character.isWhitespace(text.charAt(i))) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        protected void setLeadingGaps() {
            ISemanticRegion token = this.firstToken;
            while (token != null) {
                IHiddenRegion gap = token.getPreviousHiddenRegion();
                EObjectTokens tokens = this.eObjToTokens.get(token.getSemanticElement());
                while (tokens != null && tokens.getLeadingGap() == null) {
                    tokens.setLeadingGap(gap);
                    tokens = this.eObjToTokens.get(tokens.getSemanticElement().eContainer());
                }
                token = token.getNextSemanticRegion();
            }
        }

        protected void setTrailingGaps() {
            ISemanticRegion token = this.lastTokenOrGap instanceof IHiddenRegion ? ((IHiddenRegion)this.lastTokenOrGap).getPreviousSemanticRegion() : (ISemanticRegion)this.lastTokenOrGap;
            while (token != null) {
                IHiddenRegion gap = token.getNextHiddenRegion();
                EObjectTokens tokens = this.eObjToTokens.get(token.getSemanticElement());
                while (tokens != null && tokens.getTrailingGap() == null) {
                    tokens.setTrailingGap(gap);
                    tokens = this.eObjToTokens.get(tokens.getSemanticElement().eContainer());
                }
                token = token.getPreviousSemanticRegion();
            }
        }

        public Builder withResource(XtextResource resource) {
            this.resource = resource;
            return this;
        }
    }
}

