/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.internal;

import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.resource.IResourceServiceProvider;

public class ResourceServiceProviderDescriptor
implements IResourceServiceProvider.Provider {
    private static final Logger log = Logger.getLogger(ResourceServiceProviderDescriptor.class);
    private IConfigurationElement element;
    private String attClass;
    private Object extension;

    public ResourceServiceProviderDescriptor(IConfigurationElement element, String attClass) {
        this.element = element;
        this.attClass = attClass;
    }

    public IConfigurationElement getElement() {
        return this.element;
    }

    @Override
    public synchronized IResourceServiceProvider get(URI uri, String contentType) {
        if (this.extension == null) {
            try {
                this.extension = this.element.createExecutableExtension(this.attClass);
            }
            catch (CoreException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (NoClassDefFoundError e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (this.extension instanceof IResourceServiceProvider.Provider) {
            IResourceServiceProvider.Provider provider = (IResourceServiceProvider.Provider)this.extension;
            IResourceServiceProvider result = provider.get(uri, contentType);
            return result;
        }
        if (this.extension instanceof IResourceServiceProvider) {
            return (IResourceServiceProvider)this.extension;
        }
        String type = this.extension == null ? "null" : this.extension.getClass().getName();
        String valid = IResourceServiceProvider.class + " or " + IResourceServiceProvider.Provider.class;
        String suffix = "";
        if (this.element != null && this.element.getDeclaringExtension() != null && this.element.getDeclaringExtension().getContributor() != null) {
            suffix = String.valueOf(suffix) + " contributed by " + this.element.getDeclaringExtension().getContributor();
        }
        throw new ClassCastException("The type " + type + " is not a valid " + valid + suffix);
    }
}

