/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.code.editor.ldef.text.fx.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.fx.code.editor.ldef.lDef.Keyword;
import org.eclipse.fx.code.editor.ldef.lDef.LanguageDef;
import org.eclipse.fx.code.editor.ldef.lDef.LexicalPartitionHighlighting_Rule;
import org.eclipse.fx.code.editor.ldef.lDef.Scanner;
import org.eclipse.fx.code.editor.ldef.lDef.Scanner_CharacterRule;
import org.eclipse.fx.code.editor.ldef.lDef.Scanner_Keyword;
import org.eclipse.fx.code.editor.ldef.lDef.Scanner_MultiLineRule;
import org.eclipse.fx.code.editor.ldef.lDef.Scanner_PatternRule;
import org.eclipse.fx.code.editor.ldef.lDef.Scanner_SingleLineRule;
import org.eclipse.fx.text.RegexRule;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.CombinedWordRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.source.CharacterRule;
import org.eclipse.jface.text.source.JavaLikeWordDetector;

public class LDefRuleScanner
extends RuleBasedScanner {
    public LDefRuleScanner(LexicalPartitionHighlighting_Rule scanner) {
        Token defaultToken = null;
        IRule[] rules = new IRule[LDefRuleScanner.getRuleCount(scanner)];
        int i = 0;
        HashMap<Token, Scanner_Keyword> keyWordList = new HashMap<Token, Scanner_Keyword>();
        for (org.eclipse.fx.code.editor.ldef.lDef.Token st : scanner.getTokenList()) {
            Token token = new Token((Object)new TextAttribute(String.valueOf(((LanguageDef)scanner.eContainer().eContainer()).getName()) + "." + st.getName()));
            if (st.isDefault()) {
                defaultToken = token;
                this.setDefaultReturnToken((IToken)token);
            }
            for (Scanner ru : st.getScannerList()) {
                if (ru instanceof Scanner_SingleLineRule) {
                    Scanner_SingleLineRule sru = (Scanner_SingleLineRule)ru;
                    rules[i++] = new SingleLineRule(sru.getStartSeq(), sru.getEndSeq(), (IToken)token, sru.getEscapeSeq() != null ? sru.getEscapeSeq().charAt(0) : (char)'\u0000', false);
                    continue;
                }
                if (ru instanceof Scanner_MultiLineRule) {
                    Scanner_MultiLineRule sml = (Scanner_MultiLineRule)ru;
                    rules[i++] = new MultiLineRule(sml.getStartSeq(), sml.getEndSeq(), (IToken)token, sml.getEscapeSeq() != null ? sml.getEscapeSeq().charAt(0) : (char)'\u0000', false);
                    continue;
                }
                if (ru instanceof Scanner_CharacterRule) {
                    Scanner_CharacterRule scr = (Scanner_CharacterRule)ru;
                    char[] c = new char[scr.getCharacters().size()];
                    int j = 0;
                    while (j < c.length) {
                        c[j] = ((String)scr.getCharacters().get(j)).charAt(0);
                        ++j;
                    }
                    rules[i++] = new CharacterRule((IToken)token, c);
                    continue;
                }
                if (ru instanceof Scanner_Keyword) {
                    keyWordList.put(token, (Scanner_Keyword)ru);
                    continue;
                }
                if (!(ru instanceof Scanner_PatternRule)) continue;
                Scanner_PatternRule rr = (Scanner_PatternRule)ru;
                rules[i++] = new RegexRule((IToken)token, Pattern.compile(rr.getStartPattern()), Math.max(1, rr.getLength()), Pattern.compile(rr.getContentPattern()));
            }
        }
        if (scanner.getWhitespace() != null) {
            if (scanner.getWhitespace().isJavawhitespace()) {
                rules[i++] = new WhitespaceRule(new IWhitespaceDetector(){

                    public boolean isWhitespace(char c) {
                        return Character.isWhitespace(c);
                    }
                });
            } else {
                rules[i++] = new WhitespaceRule((IWhitespaceDetector)(scanner.getWhitespace().getFileURI() != null ? new JSWSDectector() : new FixedCharacterWSDetector((List<String>)scanner.getWhitespace().getCharacters())));
            }
        }
        if (!keyWordList.isEmpty()) {
            JavaLikeWordDetector wordDetector = new JavaLikeWordDetector();
            CombinedWordRule combinedWordRule = new CombinedWordRule((IWordDetector)wordDetector, defaultToken);
            for (Map.Entry kg : keyWordList.entrySet()) {
                CombinedWordRule.WordMatcher wordRule = new CombinedWordRule.WordMatcher();
                for (Keyword k : ((Scanner_Keyword)kg.getValue()).getKeywords()) {
                    wordRule.addWord(k.getName(), (IToken)kg.getKey());
                }
                combinedWordRule.addWordMatcher(wordRule);
            }
            rules[rules.length - 1] = combinedWordRule;
        }
        this.setRules(rules);
    }

    private static int getRuleCount(LexicalPartitionHighlighting_Rule scanner) {
        int rv = 0;
        boolean hasKeyGroup = false;
        for (org.eclipse.fx.code.editor.ldef.lDef.Token token : scanner.getTokenList()) {
            rv = (int)((long)rv + token.getScannerList().stream().filter(s -> !(s instanceof Scanner_Keyword)).count());
            if (token.getScannerList().stream().filter(s -> s instanceof Scanner_Keyword).count() <= 0L) continue;
            hasKeyGroup = true;
        }
        if (hasKeyGroup) {
            ++rv;
        }
        if (scanner.getWhitespace() != null) {
            ++rv;
        }
        return rv;
    }

    static class FixedCharacterWSDetector
    implements IWhitespaceDetector {
        private final char[] chars;

        public FixedCharacterWSDetector(List<String> list) {
            this.chars = new char[list.size()];
            int i = 0;
            for (String s : list) {
                this.chars[i++] = s.charAt(0);
            }
        }

        public boolean isWhitespace(char c) {
            char[] cArray = this.chars;
            int n = this.chars.length;
            int n2 = 0;
            while (n2 < n) {
                char ch = cArray[n2];
                if (ch == c) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }

    static class JSWSDectector
    implements IWhitespaceDetector {
        JSWSDectector() {
        }

        public boolean isWhitespace(char c) {
            return false;
        }
    }
}

