/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.felix.scr.impl.logger.BundleLogger;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;
import org.apache.felix.scr.impl.metadata.DSVersion;
import org.apache.felix.scr.impl.metadata.PropertyMetadata;
import org.apache.felix.scr.impl.metadata.ReferenceMetadata;
import org.apache.felix.scr.impl.metadata.ServiceMetadata;
import org.apache.felix.scr.impl.parser.KXml2SAXHandler;
import org.apache.felix.scr.impl.parser.KXml2SAXParser;
import org.apache.felix.scr.impl.parser.ParseException;
import org.apache.felix.scr.impl.xml.XmlConstants;
import org.osgi.framework.Bundle;

public class XmlHandler
implements KXml2SAXHandler {
    private final Bundle m_bundle;
    private final BundleLogger m_logger;
    private final boolean m_globalObsoleteFactoryComponentFactory;
    private final boolean m_globalDelayedKeepInstances;
    private ComponentMetadata m_currentComponent;
    private ServiceMetadata m_currentService;
    private List<ComponentMetadata> m_components = new ArrayList<ComponentMetadata>();
    private PropertyMetadata m_pendingProperty;
    private PropertyMetadata m_pendingFactoryProperty;
    protected boolean firstElement = true;
    protected String overrideNamespace;
    protected boolean isComponent = false;

    public XmlHandler(Bundle bundle, BundleLogger logger, boolean globalObsoleteFactoryComponentFactory, boolean globalDelayedKeepInstances) {
        this.m_bundle = bundle;
        this.m_logger = logger;
        this.m_globalObsoleteFactoryComponentFactory = globalObsoleteFactoryComponentFactory;
        this.m_globalDelayedKeepInstances = globalDelayedKeepInstances;
    }

    public List<ComponentMetadata> getComponentMetadataList() {
        return this.m_components;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String uri, String localName, KXml2SAXParser.Attributes attributes) throws ParseException {
        DSVersion namespaceCode;
        if (this.firstElement) {
            this.firstElement = false;
            if (localName.equals("component") && "".equals(uri)) {
                this.overrideNamespace = "http://www.osgi.org/xmlns/scr/v1.0.0";
            }
        }
        if (this.overrideNamespace != null && "".equals(uri)) {
            uri = this.overrideNamespace;
        }
        if (this.isComponent && "".equals(uri)) {
            uri = "http://www.osgi.org/xmlns/scr/v1.0.0";
        }
        if ((namespaceCode = XmlConstants.NAMESPACE_CODE_MAP.get(uri)) != null) {
            try {
                if (localName.equals("component")) {
                    String init;
                    String configurationPidString;
                    this.isComponent = true;
                    this.m_currentComponent = new ComponentMetadata(namespaceCode);
                    if (attributes.getAttribute("name") != null) {
                        this.m_currentComponent.setName(attributes.getAttribute("name"));
                    }
                    if (attributes.getAttribute("enabled") != null) {
                        this.m_currentComponent.setEnabled(attributes.getAttribute("enabled").equals("true"));
                    }
                    if (attributes.getAttribute("immediate") != null) {
                        this.m_currentComponent.setImmediate(attributes.getAttribute("immediate").equals("true"));
                    }
                    if (attributes.getAttribute("factory") != null) {
                        this.m_currentComponent.setFactoryIdentifier(attributes.getAttribute("factory"));
                    }
                    if (attributes.getAttribute("configuration-policy") != null) {
                        this.m_currentComponent.setConfigurationPolicy(attributes.getAttribute("configuration-policy"));
                    }
                    if (attributes.getAttribute("activate") != null) {
                        this.m_currentComponent.setActivate(attributes.getAttribute("activate"));
                    }
                    if (attributes.getAttribute("deactivate") != null) {
                        this.m_currentComponent.setDeactivate(attributes.getAttribute("deactivate"));
                    }
                    if (attributes.getAttribute("modified") != null) {
                        this.m_currentComponent.setModified(attributes.getAttribute("modified"));
                    }
                    if ((configurationPidString = attributes.getAttribute("configuration-pid")) != null) {
                        String[] configurationPid = configurationPidString.split(" ");
                        this.m_currentComponent.setConfigurationPid(configurationPid);
                    }
                    this.m_currentComponent.setConfigurableServiceProperties("true".equals(attributes.getAttribute("http://felix.apache.org/xmlns/scr/extensions/v1.0.0", "configurableServiceProperties")));
                    this.m_currentComponent.setPersistentFactoryComponent("true".equals(attributes.getAttribute("http://felix.apache.org/xmlns/scr/extensions/v1.0.0", "persistentFactoryComponent")));
                    this.m_currentComponent.setDeleteCallsModify("true".equals(attributes.getAttribute("http://felix.apache.org/xmlns/scr/extensions/v1.0.0", "deleteCallsModify")));
                    if (attributes.getAttribute("http://felix.apache.org/xmlns/scr/extensions/v1.0.0", "obsoleteFactoryComponentFactory") != null) {
                        this.m_currentComponent.setObsoleteFactoryComponentFactory("true".equals(attributes.getAttribute("http://felix.apache.org/xmlns/scr/extensions/v1.0.0", "obsoleteFactoryComponentFactory")));
                    } else if (!namespaceCode.isDS13()) {
                        this.m_currentComponent.setObsoleteFactoryComponentFactory(this.m_globalObsoleteFactoryComponentFactory);
                    }
                    this.m_currentComponent.setConfigureWithInterfaces("true".equals(attributes.getAttribute("http://felix.apache.org/xmlns/scr/extensions/v1.0.0", "configureWithInterfaces")));
                    this.m_currentComponent.setDelayedKeepInstances(this.m_globalDelayedKeepInstances || "true".equals(attributes.getAttribute("http://felix.apache.org/xmlns/scr/extensions/v1.0.0", "delayedKeepInstances")));
                    String activationFields = attributes.getAttribute("activation-fields");
                    if (activationFields != null) {
                        String[] fields = activationFields.split(" ");
                        this.m_currentComponent.setActivationFields(fields);
                    }
                    if ((init = attributes.getAttribute("init")) != null) {
                        this.m_currentComponent.setInit(init);
                    }
                    this.m_components.add(this.m_currentComponent);
                    return;
                }
                if (!this.isComponent) {
                    this.m_logger.log(4, "Not currently parsing a component; ignoring element {0} (bundle {1})", null, localName, this.m_bundle.getLocation());
                    return;
                }
                if (localName.equals("implementation")) {
                    this.m_currentComponent.setImplementationClassName(attributes.getAttribute("class"));
                    return;
                }
                if (localName.equals("property")) {
                    PropertyMetadata prop = new PropertyMetadata();
                    prop.setName(attributes.getAttribute("name"));
                    if (attributes.getAttribute("type") != null) {
                        prop.setType(attributes.getAttribute("type"));
                    }
                    if (attributes.getAttribute("value") != null) {
                        prop.setValue(attributes.getAttribute("value"));
                        this.m_currentComponent.addProperty(prop);
                        return;
                    }
                    this.m_pendingProperty = prop;
                    return;
                }
                if (localName.equals("properties")) {
                    Properties props = this.readPropertiesEntry(attributes.getAttribute("entry"));
                    for (Map.Entry<Object, Object> pEntry : props.entrySet()) {
                        PropertyMetadata prop = new PropertyMetadata();
                        prop.setName(String.valueOf(pEntry.getKey()));
                        prop.setValue(String.valueOf(pEntry.getValue()));
                        this.m_currentComponent.addProperty(prop);
                    }
                    return;
                }
                if (localName.equals("factory-property")) {
                    PropertyMetadata prop = new PropertyMetadata();
                    prop.setName(attributes.getAttribute("name"));
                    if (attributes.getAttribute("type") != null) {
                        prop.setType(attributes.getAttribute("type"));
                    }
                    if (attributes.getAttribute("value") != null) {
                        prop.setValue(attributes.getAttribute("value"));
                        this.m_currentComponent.addFactoryProperty(prop);
                        return;
                    }
                    this.m_pendingFactoryProperty = prop;
                    return;
                }
                if (localName.equals("factory-properties")) {
                    Properties props = this.readPropertiesEntry(attributes.getAttribute("entry"));
                    for (Map.Entry<Object, Object> pEntry : props.entrySet()) {
                        PropertyMetadata prop = new PropertyMetadata();
                        prop.setName(String.valueOf(pEntry.getKey()));
                        prop.setValue(String.valueOf(pEntry.getValue()));
                        this.m_currentComponent.addFactoryProperty(prop);
                    }
                    return;
                }
                if (localName.equals("service")) {
                    this.m_currentService = new ServiceMetadata();
                    if (attributes.getAttribute("servicefactory") != null) {
                        this.m_currentService.setServiceFactory(attributes.getAttribute("servicefactory").equals("true"));
                    }
                    if (attributes.getAttribute("scope") != null) {
                        this.m_currentService.setScope(attributes.getAttribute("scope"));
                    }
                    this.m_currentComponent.setService(this.m_currentService);
                    return;
                }
                if (localName.equals("provide")) {
                    this.m_currentService.addProvide(attributes.getAttribute("interface"));
                    return;
                }
                if (localName.equals("reference")) {
                    ReferenceMetadata ref = new ReferenceMetadata();
                    if (attributes.getAttribute("name") != null) {
                        ref.setName(attributes.getAttribute("name"));
                    }
                    ref.setInterface(attributes.getAttribute("interface"));
                    if (attributes.getAttribute("cardinality") != null) {
                        ref.setCardinality(attributes.getAttribute("cardinality"));
                    }
                    if (attributes.getAttribute("policy") != null) {
                        ref.setPolicy(attributes.getAttribute("policy"));
                    }
                    if (attributes.getAttribute("policy-option") != null) {
                        ref.setPolicyOption(attributes.getAttribute("policy-option"));
                    }
                    if (attributes.getAttribute("scope") != null) {
                        ref.setScope(attributes.getAttribute("scope"));
                    }
                    if (attributes.getAttribute("target") != null) {
                        ref.setTarget(attributes.getAttribute("target"));
                        PropertyMetadata prop = new PropertyMetadata();
                        prop.setName((ref.getName() == null ? ref.getInterface() : ref.getName()) + ".target");
                        prop.setValue(attributes.getAttribute("target"));
                        this.m_currentComponent.addProperty(prop);
                    }
                    ref.setBind(attributes.getAttribute("bind"));
                    ref.setUpdated(attributes.getAttribute("updated"));
                    ref.setUnbind(attributes.getAttribute("unbind"));
                    ref.setField(attributes.getAttribute("field"));
                    ref.setFieldOption(attributes.getAttribute("field-option"));
                    ref.setFieldCollectionType(attributes.getAttribute("field-collection-type"));
                    if (attributes.getAttribute("parameter") != null) {
                        ref.setParameter(attributes.getAttribute("parameter"));
                    }
                    this.m_currentComponent.addDependency(ref);
                    return;
                }
                if (localName.equals("components")) return;
                this.m_logger.log(4, "Ignoring unsupported element {0} (bundle {1})", null, localName, this.m_bundle.getLocation());
                return;
            }
            catch (Exception ex) {
                throw new ParseException("Exception during parsing", ex);
            }
        } else {
            if (localName.equals("components")) return;
            this.m_logger.log(4, "Ignoring unsupported element '{'{0}'}'{1} (bundle {2})", null, uri, localName, this.m_bundle.getLocation());
        }
    }

    @Override
    public void endElement(String uri, String localName) {
        if (this.overrideNamespace != null && "".equals(uri)) {
            uri = this.overrideNamespace;
        }
        if (this.isComponent && "".equals(uri)) {
            uri = "http://www.osgi.org/xmlns/scr/v1.0.0";
        }
        if ("http://www.osgi.org/xmlns/scr/v1.0.0".equals(uri)) {
            if (localName.equals("component")) {
                this.isComponent = false;
            } else if (localName.equals("property") && this.m_pendingProperty != null) {
                this.m_pendingProperty = null;
            } else if (localName.equals("factory-property") && this.m_pendingFactoryProperty != null) {
                this.m_pendingFactoryProperty = null;
            }
        }
    }

    @Override
    public void characters(String text) {
        if (this.m_pendingProperty != null) {
            this.m_pendingProperty.setValues(text);
            this.m_currentComponent.addProperty(this.m_pendingProperty);
            this.m_pendingProperty = null;
        }
        if (this.m_pendingFactoryProperty != null) {
            this.m_pendingFactoryProperty.setValues(text);
            this.m_currentComponent.addFactoryProperty(this.m_pendingFactoryProperty);
            this.m_pendingFactoryProperty = null;
        }
    }

    @Override
    public void processingInstruction(String target, String data) {
    }

    @Override
    public void setLineNumber(int lineNumber) {
    }

    @Override
    public void setColumnNumber(int columnNumber) {
    }

    private Properties readPropertiesEntry(String entryName) throws ParseException {
        if (entryName == null) {
            throw new ParseException("Missing entry attribute of properties element", null);
        }
        URL entryURL = this.m_bundle.getEntry(entryName);
        if (entryURL == null) {
            throw new ParseException("Missing bundle entry " + entryName, null);
        }
        Properties props = new Properties();
        InputStream entryStream = null;
        try {
            entryStream = entryURL.openStream();
            props.load(entryStream);
        }
        catch (IOException ioe) {
            throw new ParseException("Failed to read properties entry " + entryName, ioe);
        }
        finally {
            if (entryStream != null) {
                try {
                    entryStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return props;
    }
}

