/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.ext.auth.KeyStoreOptions;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Map;

public class KeyStoreOptionsConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    public static void fromJson(Iterable<Map.Entry<String, Object>> json, KeyStoreOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "password": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setPassword((String)member.getValue());
                    break;
                }
                case "passwordProtection": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof String) {
                            map.put((String)entry.getKey(), (String)entry.getValue());
                        }
                    });
                    obj.setPasswordProtection(map);
                    break;
                }
                case "path": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setPath((String)member.getValue());
                    break;
                }
                case "provider": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setProvider((String)member.getValue());
                    break;
                }
                case "type": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setType((String)member.getValue());
                    break;
                }
                case "value": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setValue(Buffer.buffer(BASE64_DECODER.decode((String)member.getValue())));
                }
            }
        }
    }

    public static void toJson(KeyStoreOptions obj, JsonObject json) {
        KeyStoreOptionsConverter.toJson(obj, json.getMap());
    }

    public static void toJson(KeyStoreOptions obj, Map<String, Object> json) {
        if (obj.getPassword() != null) {
            json.put("password", obj.getPassword());
        }
        if (obj.getPasswordProtection() != null) {
            JsonObject map = new JsonObject();
            obj.getPasswordProtection().forEach((key, value) -> map.put((String)key, value));
            json.put("passwordProtection", map);
        }
        if (obj.getPath() != null) {
            json.put("path", obj.getPath());
        }
        if (obj.getProvider() != null) {
            json.put("provider", obj.getProvider());
        }
        if (obj.getType() != null) {
            json.put("type", obj.getType());
        }
        if (obj.getValue() != null) {
            json.put("value", BASE64_ENCODER.encodeToString(obj.getValue().getBytes()));
        }
    }
}

