/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.amqp.connection;

import io.vertx.proton.ProtonHelper;
import java.util.Objects;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;

public final class AmqpErrorException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final String error;

    public AmqpErrorException(Symbol error, String description) {
        this(error.toString(), description);
    }

    public AmqpErrorException(String error, String description) {
        super(description);
        this.error = Objects.requireNonNull(error);
    }

    public static AmqpErrorException from(DeliveryState deliveryState) {
        switch (deliveryState.getType()) {
            case Accepted: {
                throw new IllegalArgumentException("cannot create exception from accepted delivery state");
            }
            case Rejected: {
                Rejected rejected = (Rejected)deliveryState;
                if (rejected.getError() == null) break;
                return new AmqpErrorException(rejected.getError().getCondition(), rejected.getError().getDescription());
            }
        }
        return new AmqpErrorException(deliveryState.getType().toString(), "peer did not accept message: %s".formatted(deliveryState.getType().toString()));
    }

    public Symbol getError() {
        return Symbol.valueOf(this.error);
    }

    public ErrorCondition asErrorCondition() {
        return ProtonHelper.condition(this.error.toString(), this.getMessage());
    }
}

