/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kafka.client.runtime.graal;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import javax.security.auth.AuthPermission;
import javax.security.auth.Subject;
import javax.security.auth.SubjectDomainCombiner;
import org.graalvm.home.Version;

@TargetClass(className="javax.security.auth.Subject", onlyWith={Graal22_0OrEarlier.class})
final class Target_javax_security_auth_Subject {
    Target_javax_security_auth_Subject() {
    }

    @Substitute
    public static <T> T doAs(Subject subject, PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(AuthPermissionHolder.DO_AS_PERMISSION);
        }
        if (action == null) {
            throw new NullPointerException("Invalid null action provided");
        }
        AccessControlContext currentAcc = AccessController.getContext();
        SubjectHolder.subjects.put(currentAcc, subject);
        return AccessController.doPrivileged(action, Target_javax_security_auth_Subject.createContext(subject, currentAcc));
    }

    @Substitute
    public static Subject getSubject(final AccessControlContext acc) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(AuthPermissionHolder.GET_SUBJECT_PERMISSION);
        }
        if (acc == null) {
            throw new NullPointerException("Invalid null AccessControlContext provided");
        }
        return AccessController.doPrivileged(new PrivilegedAction<Subject>(){

            @Override
            public Subject run() {
                return SubjectHolder.subjects.getIfPresent(acc);
            }
        });
    }

    @Substitute
    private static AccessControlContext createContext(final Subject subject, final AccessControlContext acc) {
        return AccessController.doPrivileged(new PrivilegedAction<AccessControlContext>(){

            @Override
            public AccessControlContext run() {
                if (subject == null) {
                    return new AccessControlContext(acc, null);
                }
                return new AccessControlContext(acc, new SubjectDomainCombiner(subject));
            }
        });
    }

    public static final class Graal22_0OrEarlier
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return Version.getCurrent().compareTo(22, 1) < 0;
        }
    }

    static final class SubjectHolder {
        static final Cache<AccessControlContext, Subject> subjects = Caffeine.newBuilder().initialCapacity(20).maximumSize(1000L).expireAfterWrite(1L, TimeUnit.MINUTES).expireAfterAccess(1L, TimeUnit.SECONDS).build();

        SubjectHolder() {
        }
    }

    static final class AuthPermissionHolder {
        static final AuthPermission DO_AS_PERMISSION = new AuthPermission("doAs");
        static final AuthPermission DO_AS_PRIVILEGED_PERMISSION = new AuthPermission("doAsPrivileged");
        static final AuthPermission SET_READ_ONLY_PERMISSION = new AuthPermission("setReadOnly");
        static final AuthPermission GET_SUBJECT_PERMISSION = new AuthPermission("getSubject");
        static final AuthPermission MODIFY_PRINCIPALS_PERMISSION = new AuthPermission("modifyPrincipals");
        static final AuthPermission MODIFY_PUBLIC_CREDENTIALS_PERMISSION = new AuthPermission("modifyPublicCredentials");
        static final AuthPermission MODIFY_PRIVATE_CREDENTIALS_PERMISSION = new AuthPermission("modifyPrivateCredentials");

        AuthPermissionHolder() {
        }
    }
}

