/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.configuration.ConfigurationRuntimeConfig;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

@Recorder
public class ConfigRecorder {
    private static final Logger log = Logger.getLogger(ConfigRecorder.class);
    final ConfigurationRuntimeConfig configurationConfig;

    public ConfigRecorder(ConfigurationRuntimeConfig configurationConfig) {
        this.configurationConfig = configurationConfig;
    }

    public void handleConfigChange(Map<String, String> buildTimeConfig) {
        Config configProvider = ConfigProvider.getConfig();
        ArrayList<CallSite> mismatches = null;
        for (Map.Entry<String, String> entry : buildTimeConfig.entrySet()) {
            Optional<String> val = configProvider.getOptionalValue(entry.getKey(), String.class);
            if (!val.isPresent() || val.get().equals(entry.getValue())) continue;
            if (mismatches == null) {
                mismatches = new ArrayList<CallSite>();
            }
            mismatches.add((CallSite)((Object)(" - " + entry.getKey() + " is set to '" + entry.getValue() + "' but it is build time fixed to '" + val.get() + "'. Did you change the property " + entry.getKey() + " after building the application?")));
        }
        if (mismatches != null && !mismatches.isEmpty()) {
            String msg = "Build time property cannot be changed at runtime:\n" + mismatches.stream().collect(Collectors.joining("\n"));
            switch (this.configurationConfig.buildTimeMismatchAtRuntime) {
                case fail: {
                    throw new IllegalStateException(msg);
                }
                case warn: {
                    log.warn(msg);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected " + ConfigurationRuntimeConfig.BuildTimeMismatchAtRuntime.class.getName() + ": " + this.configurationConfig.buildTimeMismatchAtRuntime);
                }
            }
        }
    }
}

