/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.AbstractMappingConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Priority;

@Priority(value=3600)
public class FallbackConfigSourceInterceptor
extends AbstractMappingConfigSourceInterceptor {
    private static final long serialVersionUID = 1472367702046537565L;

    public FallbackConfigSourceInterceptor(Function<String, String> mapping) {
        super(mapping);
    }

    public FallbackConfigSourceInterceptor(Map<String, String> mappings) {
        super(mappings);
    }

    @Override
    public ConfigValue getValue(ConfigSourceInterceptorContext context, String name) {
        ConfigValue configValue = context.proceed(name);
        String map = this.getMapping().apply(name);
        if (name.equals(map)) {
            return configValue;
        }
        ConfigValue fallbackValue = context.proceed(map);
        if (configValue != null && fallbackValue != null) {
            return ConfigValue.CONFIG_SOURCE_COMPARATOR.compare(configValue, fallbackValue) >= 0 ? configValue : fallbackValue;
        }
        return configValue != null ? configValue : fallbackValue;
    }
}

