/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.util;

import io.vertx.core.json.JsonObject;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonHelper {
    private static final Logger LOG = LoggerFactory.getLogger(JsonHelper.class);

    private JsonHelper() {
    }

    public static <T> T getValue(JsonObject jsonObject, String name, Class<T> clazz, T defaultValue) {
        Objects.requireNonNull(jsonObject);
        Objects.requireNonNull(name);
        Objects.requireNonNull(clazz);
        if (clazz == byte[].class) {
            try {
                byte[] binaryValue = jsonObject.getBinary(name);
                if (binaryValue == null) {
                    return defaultValue;
                }
                return clazz.cast(binaryValue);
            }
            catch (ClassCastException | IllegalArgumentException e) {
                LOG.debug("field [{}] does not contain a proper base64 string", (Object)name, (Object)e);
                return defaultValue;
            }
        }
        Object value = jsonObject.getValue(name, defaultValue);
        if (value == null) {
            return defaultValue;
        }
        try {
            return clazz.cast(value);
        }
        catch (ClassCastException e) {
            LOG.debug("unexpected value type for field [{}]: {}; expected: {}", name, value.getClass().getSimpleName(), clazz.getSimpleName());
            return defaultValue;
        }
    }
}

