/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.runtime;

import io.netty.util.concurrent.FastThreadLocal;
import io.quarkus.arc.CurrentContext;
import io.quarkus.arc.CurrentContextFactory;
import io.quarkus.arc.InjectableContext;
import io.quarkus.vertx.core.runtime.context.VertxContextSafetyToggle;
import io.smallrye.common.vertx.VertxContext;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import java.lang.annotation.Annotation;

public class VertxCurrentContextFactory
implements CurrentContextFactory {
    public static final String LOCAL_KEY = "io.quarkus.vertx.cdi-current-context";

    @Override
    public <T extends InjectableContext.ContextState> CurrentContext<T> create(Class<? extends Annotation> scope) {
        return new VertxCurrentContext();
    }

    private static final class VertxCurrentContext<T extends InjectableContext.ContextState>
    implements CurrentContext<T> {
        private final FastThreadLocal<T> fallback = new FastThreadLocal();

        private VertxCurrentContext() {
        }

        @Override
        public T get() {
            Context context = Vertx.currentContext();
            if (context != null && VertxContext.isDuplicatedContext(context)) {
                return (T)((InjectableContext.ContextState)context.getLocal(VertxCurrentContextFactory.LOCAL_KEY));
            }
            return (T)((InjectableContext.ContextState)this.fallback.get());
        }

        @Override
        public void set(T state) {
            Context context = Vertx.currentContext();
            if (context != null && VertxContext.isDuplicatedContext(context)) {
                VertxContextSafetyToggle.setContextSafe(context, true);
                context.putLocal(VertxCurrentContextFactory.LOCAL_KEY, state);
            } else {
                this.fallback.set(state);
            }
        }

        @Override
        public void remove() {
            Context context = Vertx.currentContext();
            if (context == null || !VertxContext.isDuplicatedContext(context)) {
                this.fallback.remove();
            }
        }
    }
}

