/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.function;

import io.smallrye.common.constraint.Assert;
import io.smallrye.common.function.ExceptionRunnable;
import io.smallrye.common.function.ExceptionSupplier;

@FunctionalInterface
public interface ExceptionConsumer<T, E extends Exception> {
    public void accept(T var1) throws E;

    default public ExceptionConsumer<T, E> andThen(ExceptionConsumer<? super T, ? extends E> after) {
        Assert.checkNotNullParam("after", after);
        return t -> {
            this.accept(t);
            after.accept(t);
        };
    }

    default public ExceptionConsumer<T, E> compose(ExceptionConsumer<? super T, ? extends E> before) {
        Assert.checkNotNullParam("before", before);
        return t -> {
            this.accept(t);
            before.accept(t);
        };
    }

    default public ExceptionRunnable<E> compose(ExceptionSupplier<? extends T, ? extends E> before) {
        Assert.checkNotNullParam("before", before);
        return () -> this.accept(before.get());
    }
}

