/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.kafka.client.common;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.kafka.client.common.Node;
import io.vertx.kafka.client.common.PartitionInfo;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;

public class PartitionInfoConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    public static void fromJson(Iterable<Map.Entry<String, Object>> json, PartitionInfo obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "inSyncReplicas": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Node> list = new ArrayList<Node>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            list.add(new Node((JsonObject)item));
                        }
                    });
                    obj.setInSyncReplicas(list);
                    break;
                }
                case "leader": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setLeader(new Node((JsonObject)member.getValue()));
                    break;
                }
                case "partition": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setPartition(((Number)member.getValue()).intValue());
                    break;
                }
                case "replicas": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Node> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            list.add(new Node((JsonObject)item));
                        }
                    });
                    obj.setReplicas(list);
                    break;
                }
                case "topic": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setTopic((String)member.getValue());
                }
            }
        }
    }

    public static void toJson(PartitionInfo obj, JsonObject json) {
        PartitionInfoConverter.toJson(obj, json.getMap());
    }

    public static void toJson(PartitionInfo obj, Map<String, Object> json) {
        JsonArray array;
        if (obj.getInSyncReplicas() != null) {
            array = new JsonArray();
            obj.getInSyncReplicas().forEach(item -> array.add(item.toJson()));
            json.put("inSyncReplicas", array);
        }
        if (obj.getLeader() != null) {
            json.put("leader", obj.getLeader().toJson());
        }
        json.put("partition", obj.getPartition());
        if (obj.getReplicas() != null) {
            array = new JsonArray();
            obj.getReplicas().forEach(item -> array.add(item.toJson()));
            json.put("replicas", array);
        }
        if (obj.getTopic() != null) {
            json.put("topic", obj.getTopic());
        }
    }
}

