/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.kafka.client.common;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.kafka.client.common.ConfigResource;
import java.util.Base64;
import java.util.Map;
import org.apache.kafka.common.config.ConfigResource;

public class ConfigResourceConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    static void fromJson(Iterable<Map.Entry<String, Object>> json, ConfigResource obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "default": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setDefault((Boolean)member.getValue());
                    break;
                }
                case "name": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setName((String)member.getValue());
                    break;
                }
                case "type": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setType(ConfigResource.Type.valueOf((String)member.getValue()));
                }
            }
        }
    }

    static void toJson(ConfigResource obj, JsonObject json) {
        ConfigResourceConverter.toJson(obj, json.getMap());
    }

    static void toJson(ConfigResource obj, Map<String, Object> json) {
        json.put("default", obj.isDefault());
        if (obj.getName() != null) {
            json.put("name", obj.getName());
        }
        if (obj.getType() != null) {
            json.put("type", obj.getType().name());
        }
    }
}

