/**
 * Copyright (c) 2010-2012, Abel Hegedus, Istvan Rath and Daniel Varro
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Abel Hegedus - initial API and implementation
 */
package org.eclipse.incquery.querybasedfeatures.tooling;

import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.incquery.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.querybasedfeatures.runtime.QueryBasedFeatureKind;
import org.eclipse.xtend2.lib.StringConcatenation;

@SuppressWarnings("all")
public class DerivedFeatureSourceCodeUtil {
  public CharSequence methodBody(final GenClass source, final GenFeature feature, final Pattern pattern, final String sourceParamName, final String targetParamName, final QueryBasedFeatureKind kind, final boolean keepCache) {
    CharSequence _switchResult = null;
    if (kind != null) {
      switch (kind) {
        case SINGLE_REFERENCE:
          _switchResult = this.singleRefGetMethod(source, feature, pattern, sourceParamName, targetParamName, keepCache);
          break;
        case MANY_REFERENCE:
          _switchResult = this.manyRefGetMethod(source, feature, pattern, sourceParamName, targetParamName, keepCache);
          break;
        case SUM:
          _switchResult = this.sumGetMethod(source, feature, pattern, sourceParamName, targetParamName);
          break;
        case ITERATION:
          _switchResult = this.iterationGetMethod(source, feature, pattern, sourceParamName, targetParamName);
          break;
        default:
          break;
      }
    }
    return _switchResult;
  }
  
  public CharSequence dummyCompUnitHeader() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("import org.eclipse.emf.common.util.EList;");
    _builder.newLine();
    _builder.append("import org.eclipse.emf.ecore.EClass;");
    _builder.newLine();
    _builder.append("import org.eclipse.incquery.querybasedfeatures.runtime.IQueryBasedFeatureHandler;");
    _builder.newLine();
    _builder.append("import org.eclipse.incquery.querybasedfeatures.runtime.QueryBasedFeatureKind;");
    _builder.newLine();
    _builder.append("import org.eclipse.incquery.querybasedfeatures.runtime.QueryBasedFeatureHelper;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("public class DummyClass {");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("public void DummyMethod() {");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence singleRefGetMethod(final GenClass source, final GenFeature feature, final Pattern pattern, final String sourceParamName, final String targetParamName, final boolean keepCache) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _dummyCompUnitHeader = this.dummyCompUnitHeader();
    _builder.append(_dummyCompUnitHeader, "");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("if (");
    String _name = feature.getName();
    _builder.append(_name, "\t\t");
    _builder.append("Handler == null) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    String _name_1 = feature.getName();
    _builder.append(_name_1, "\t\t\t");
    _builder.append("Handler = QueryBasedFeatureHelper.getQueryBasedFeatureHandler(this,");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    GenPackage _genPackage = source.getGenPackage();
    String _packageClassName = _genPackage.getPackageClassName();
    _builder.append(_packageClassName, "\t\t\t\t");
    _builder.append(".Literals.");
    String _featureID = source.getFeatureID(feature);
    _builder.append(_featureID, "\t\t\t\t");
    _builder.append(",");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    _builder.append("\"");
    String _fullyQualifiedName = CorePatternLanguageHelper.getFullyQualifiedName(pattern);
    _builder.append(_fullyQualifiedName, "\t\t\t\t");
    _builder.append("\", \"");
    _builder.append(sourceParamName, "\t\t\t\t");
    _builder.append("\", \"");
    _builder.append(targetParamName, "\t\t\t\t");
    _builder.append("\",");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    _builder.append("QueryBasedFeatureKind.SINGLE_REFERENCE,");
    _builder.append(keepCache, "\t\t\t\t");
    _builder.append(", false);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return (");
    String _type = feature.getType(source);
    _builder.append(_type, "\t\t");
    _builder.append(") ");
    String _name_2 = feature.getName();
    _builder.append(_name_2, "\t\t");
    _builder.append("Handler.getSingleReferenceValue(this);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  /**
   * if («feature.name»Handler != null) {
   * return («feature.getType(source)») «feature.name»Handler.getSingleReferenceValue();
   * } else {
   * «feature.name»Handler = IncqueryFeatureHelper.createHandler(this,
   * «source.genPackage.packageClassName».Literals.«source.getFeatureID(feature)»,
   * "«pattern.fullyQualifiedName»", "«sourceParamName»", "«targetParamName»",
   * FeatureKind.SINGLE_REFERENCE,«keepCache»);
   * if («feature.name»Handler != null) {
   * return («feature.getType(source)») «feature.name»Handler.getSingleReferenceValue();
   * }
   * }
   * return null;
   */
  public CharSequence manyRefGetMethod(final GenClass source, final GenFeature feature, final Pattern pattern, final String sourceParamName, final String targetParamName, final boolean keepCache) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _dummyCompUnitHeader = this.dummyCompUnitHeader();
    _builder.append(_dummyCompUnitHeader, "");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("if(");
    String _name = feature.getName();
    _builder.append(_name, "\t\t");
    _builder.append("Handler == null) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    String _name_1 = feature.getName();
    _builder.append(_name_1, "\t\t\t");
    _builder.append("Handler = QueryBasedFeatureHelper.getQueryBasedFeatureHandler(this,");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    GenPackage _genPackage = source.getGenPackage();
    String _packageClassName = _genPackage.getPackageClassName();
    _builder.append(_packageClassName, "\t\t\t\t");
    _builder.append(".Literals.");
    String _featureID = source.getFeatureID(feature);
    _builder.append(_featureID, "\t\t\t\t");
    _builder.append(",");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    _builder.append("\"");
    String _fullyQualifiedName = CorePatternLanguageHelper.getFullyQualifiedName(pattern);
    _builder.append(_fullyQualifiedName, "\t\t\t\t");
    _builder.append("\", \"");
    _builder.append(sourceParamName, "\t\t\t\t");
    _builder.append("\", \"");
    _builder.append(targetParamName, "\t\t\t\t");
    _builder.append("\",");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    _builder.append("QueryBasedFeatureKind.MANY_REFERENCE,");
    _builder.append(keepCache, "\t\t\t\t");
    _builder.append(", false);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return ");
    String _name_2 = feature.getName();
    _builder.append(_name_2, "\t\t");
    _builder.append("Handler.getManyReferenceValueAsEList(this);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence sumGetMethod(final GenClass source, final GenFeature feature, final Pattern pattern, final String sourceParamName, final String targetParamName) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _dummyCompUnitHeader = this.dummyCompUnitHeader();
    _builder.append(_dummyCompUnitHeader, "");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("if (");
    String _name = feature.getName();
    _builder.append(_name, "\t\t");
    _builder.append("Handler == null) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    String _name_1 = feature.getName();
    _builder.append(_name_1, "\t\t\t");
    _builder.append("Handler = QueryBasedFeatureHelper.getQueryBasedFeatureHandler(this,");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    GenPackage _genPackage = source.getGenPackage();
    String _packageClassName = _genPackage.getPackageClassName();
    _builder.append(_packageClassName, "\t\t\t\t");
    _builder.append(".Literals.");
    String _featureID = source.getFeatureID(feature);
    _builder.append(_featureID, "\t\t\t\t");
    _builder.append(",");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    _builder.append("\"");
    String _fullyQualifiedName = CorePatternLanguageHelper.getFullyQualifiedName(pattern);
    _builder.append(_fullyQualifiedName, "\t\t\t\t");
    _builder.append("\", \"");
    _builder.append(sourceParamName, "\t\t\t\t");
    _builder.append("\", \"");
    _builder.append(targetParamName, "\t\t\t\t");
    _builder.append("\",");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    _builder.append("QueryBasedFeatureKind.SUM, true, false);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return ");
    String _name_2 = feature.getName();
    _builder.append(_name_2, "\t\t");
    _builder.append("Handler.getIntValue(this);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence iterationGetMethod(final GenClass source, final GenFeature feature, final Pattern pattern, final String sourceParamName, final String targetParamName) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _dummyCompUnitHeader = this.dummyCompUnitHeader();
    _builder.append(_dummyCompUnitHeader, "");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("if (");
    String _name = feature.getName();
    _builder.append(_name, "\t\t");
    _builder.append("Handler == null) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    String _name_1 = feature.getName();
    _builder.append(_name_1, "\t\t\t");
    _builder.append("Handler = QueryBasedFeatureHelper.getQueryBasedFeatureHandler(this,");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    GenPackage _genPackage = source.getGenPackage();
    String _packageClassName = _genPackage.getPackageClassName();
    _builder.append(_packageClassName, "\t\t\t\t");
    _builder.append(".Literals.");
    String _featureID = source.getFeatureID(feature);
    _builder.append(_featureID, "\t\t\t\t");
    _builder.append(",");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    _builder.append("\"");
    String _fullyQualifiedName = CorePatternLanguageHelper.getFullyQualifiedName(pattern);
    _builder.append(_fullyQualifiedName, "\t\t\t\t");
    _builder.append("\", \"");
    _builder.append(sourceParamName, "\t\t\t\t");
    _builder.append("\", \"");
    _builder.append(targetParamName, "\t\t\t\t");
    _builder.append("\",");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    _builder.append("QueryBasedFeatureKind.ITERATION, true, false);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return (");
    String _type = feature.getType(source);
    _builder.append(_type, "\t\t");
    _builder.append(") ");
    String _name_2 = feature.getName();
    _builder.append(_name_2, "\t\t");
    _builder.append("Handler.getValueIteration(this);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence singleRefSetMethod(final GenFeature feature, final Pattern pattern, final String parameter, final String setMethod, final String setExpression) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _dummyCompUnitHeader = this.dummyCompUnitHeader();
    _builder.append(_dummyCompUnitHeader, "");
    _builder.newLineIfNotEmpty();
    _builder.append("    ");
    _builder.append("if(");
    _builder.append(parameter, "    ");
    _builder.append(" != null){");
    _builder.newLineIfNotEmpty();
    _builder.append("      ");
    _builder.append(setMethod, "      ");
    _builder.append("(");
    _builder.append(setExpression, "      ");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("    ");
    _builder.append("}  else {");
    _builder.newLine();
    _builder.append("      ");
    _builder.append(setMethod, "      ");
    _builder.append("(null);");
    _builder.newLineIfNotEmpty();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence defaultMethod(final boolean manyFeature) {
    CharSequence _xifexpression = null;
    if (manyFeature) {
      _xifexpression = this.defaultListGetMethod();
    } else {
      _xifexpression = this.defaultSingleGetMethod();
    }
    return _xifexpression;
  }
  
  public CharSequence defaultSingleGetMethod() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("import java.lang.UnsupportedOperationException;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("public class DummyClass {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public void DummyMethod() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// TODO: implement this method to return the \'X\' reference");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// -> do not perform proxy resolution");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// Ensure that you remove @generated or mark it @generated NOT");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("throw new UnsupportedOperationException();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence defaultListGetMethod() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("import java.lang.UnsupportedOperationException;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("public class DummyClass {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public void DummyMethod() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// TODO: implement this method to return the \'X\' reference list");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// Ensure that you remove @generated or mark it @generated NOT");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// The list is expected to implement org.eclipse.emf.ecore.util.InternalEList and org.eclipse.emf.ecore.EStructuralFeature.Setting");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// so it\'s likely that an appropriate subclass of org.eclipse.emf.ecore.util.EcoreEList should be used.");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("throw new UnsupportedOperationException();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
}
