/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.seproxy.plugin;

import java.util.SortedSet;
import java.util.concurrent.ConcurrentSkipListSet;
import org.eclipse.keyple.seproxy.ReaderPlugin;
import org.eclipse.keyple.seproxy.event.ObservablePlugin;
import org.eclipse.keyple.seproxy.event.PluginEvent;
import org.eclipse.keyple.seproxy.exception.KeypleReaderException;
import org.eclipse.keyple.seproxy.exception.KeypleReaderNotFoundException;
import org.eclipse.keyple.seproxy.message.ProxyReader;
import org.eclipse.keyple.seproxy.plugin.AbstractLoggedObservable;
import org.eclipse.keyple.seproxy.plugin.AbstractObservableReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractObservablePlugin
extends AbstractLoggedObservable<PluginEvent>
implements ReaderPlugin {
    private static final Logger logger = LoggerFactory.getLogger(AbstractObservablePlugin.class);
    protected SortedSet<AbstractObservableReader> readers = null;

    protected AbstractObservablePlugin(String name) {
        super(name);
        if (this.readers == null) {
            try {
                this.readers = this.initNativeReaders();
            }
            catch (KeypleReaderException e) {
                e.printStackTrace();
            }
        }
    }

    public final SortedSet<AbstractObservableReader> getReaders() throws KeypleReaderException {
        if (this.readers == null) {
            throw new KeypleReaderException("List of readers has not been initialized");
        }
        return this.readers;
    }

    @Override
    public final SortedSet<String> getReaderNames() {
        ConcurrentSkipListSet<String> readerNames = new ConcurrentSkipListSet<String>();
        for (AbstractObservableReader reader : this.readers) {
            readerNames.add(reader.getName());
        }
        return readerNames;
    }

    protected abstract SortedSet<AbstractObservableReader> initNativeReaders() throws KeypleReaderException;

    protected abstract AbstractObservableReader fetchNativeReader(String var1) throws KeypleReaderException;

    protected abstract void startObservation();

    protected abstract void stopObservation();

    public final void addObserver(ObservablePlugin.PluginObserver observer) {
        super.addObserver(observer);
        if (super.countObservers() == 1) {
            logger.debug("Start the plugin monitoring.");
            this.startObservation();
        }
    }

    public final void removeObserver(ObservablePlugin.PluginObserver observer) {
        super.removeObserver(observer);
        if (super.countObservers() == 0) {
            logger.debug("Stop the plugin monitoring.");
            this.stopObservation();
        }
    }

    @Override
    public final int compareTo(ReaderPlugin plugin) {
        return this.getName().compareTo(plugin.getName());
    }

    @Override
    public final ProxyReader getReader(String name) throws KeypleReaderNotFoundException {
        for (ProxyReader proxyReader : this.readers) {
            if (!proxyReader.getName().equals(name)) continue;
            return proxyReader;
        }
        throw new KeypleReaderNotFoundException(name);
    }
}

