/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.validation.ui.decorators;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.sphinx.emf.validation.markers.ValidationMarkerManager;
import org.eclipse.sphinx.emf.validation.ui.Activator;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

public class BasicLightweightValidationDecorator
implements ILabelDecorator,
ILightweightLabelDecorator {
    protected static ImageDescriptor errorImg = new CachedImageDescriptor(Activator.getImageDescriptor("ovr16/error_co.gif"));
    protected static ImageDescriptor warningImg = new CachedImageDescriptor(Activator.getImageDescriptor("ovr16/warning_co.gif"));
    protected ValidationMarkerManager markerManager = ValidationMarkerManager.getInstance();

    public Image decorateImage(Image image, Object element) {
        return null;
    }

    public String decorateText(String text, Object element) {
        return null;
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void decorate(Object element, IDecoration decoration) {
        ImageDescriptor img = null;
        switch (this.computeValidationStatusCode(element)) {
            case 4: 
            case 5: 
            case 6: {
                img = errorImg;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                img = warningImg;
            }
        }
        if (img != null) {
            decoration.addOverlay(img, 2);
        }
    }

    public void addListener(ILabelProviderListener listener) {
    }

    protected int computeValidationStatusCode(Object element) {
        int result = 0;
        IMarker[] markers = new IMarker[]{};
        try {
            IResource resource;
            if (element instanceof EObject) {
                markers = this.markerManager.getValidationMarkersList((EObject)element, 2);
            } else if (element instanceof IResource && (resource = (IResource)element).exists() && resource.getProject() != null && resource.getProject().isAccessible()) {
                markers = resource.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            }
            if (this.markerManager.isError(markers)) {
                result = 4;
            } else if (this.markerManager.isWarning(markers)) {
                result = 1;
            }
        }
        catch (CoreException cex) {
            PlatformLogUtil.logAsWarning((Plugin)Activator.getDefault(), (Object)((Object)cex));
        }
        return result;
    }

    public static class CachedImageDescriptor
    extends ImageDescriptor {
        ImageDescriptor descriptor;
        ImageData data;

        public CachedImageDescriptor(ImageDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        public ImageData getImageData() {
            if (this.data == null) {
                this.data = this.descriptor.getImageData();
            }
            return this.data;
        }
    }
}

