/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.ui.properties.filters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.messages.EMFMessages;
import org.eclipse.sphinx.emf.ui.internal.Activator;
import org.eclipse.sphinx.emf.ui.properties.filters.IPropertySourceFilter;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.sphinx.platform.util.StatusUtil;

public final class PropertySourceFilterRegistry {
    public static final PropertySourceFilterRegistry INSTANCE = new PropertySourceFilterRegistry();
    private static final String EXTP_PROPERTY_SOURCE_FILTERS = "propertySourceFilters";
    private static final String NODE_FILTER = "filter";
    private static final String ATTR_CLASS = "class";
    private List<IPropertySourceFilter> propertySourceFilterList = new ArrayList<IPropertySourceFilter>();
    private Map<Class<?>, IPropertySourceFilter> propertySourceFilterMap = new HashMap();

    private PropertySourceFilterRegistry() {
        this.readContributedPropertySourceFilters();
    }

    public IPropertySourceFilter getPropertySourceFilter(Object owner) {
        if (owner != null) {
            Class<?> ownerType = owner.getClass();
            if (this.propertySourceFilterMap.containsKey(ownerType)) {
                return this.propertySourceFilterMap.get(ownerType);
            }
            IPropertySourceFilter filter = this.findPropertySourceFilter(owner);
            if (filter != null) {
                this.propertySourceFilterMap.put(ownerType, filter);
                return filter;
            }
        }
        return null;
    }

    private IPropertySourceFilter findPropertySourceFilter(Object owner) {
        for (IPropertySourceFilter filter : this.propertySourceFilterList) {
            if (!filter.isFilterForObject(owner)) continue;
            return filter;
        }
        return null;
    }

    private void readContributedPropertySourceFilters() {
        IConfigurationElement[] filters;
        String symbolicName = Activator.getPlugin().getSymbolicName();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = filters = registry.getConfigurationElementsFor(symbolicName, EXTP_PROPERTY_SOURCE_FILTERS);
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            block4: {
                IConfigurationElement filter = iConfigurationElementArray[n2];
                try {
                    Object object = filter.createExecutableExtension(ATTR_CLASS);
                    if (object instanceof IPropertySourceFilter) {
                        this.propertySourceFilterList.add((IPropertySourceFilter)object);
                        break block4;
                    }
                    Object[] args = new String[]{ATTR_CLASS, NODE_FILTER, filter.getDeclaringExtension().getExtensionPointUniqueIdentifier(), filter.getContributor().getName(), IPropertySourceFilter.class.getName()};
                    String msg = NLS.bind((String)EMFMessages.error_unexpectedImplementationOfElementAttributeInContribution, (Object[])args);
                    IStatus status = StatusUtil.createErrorStatus((Plugin)Activator.getPlugin(), (Object)new RuntimeException(msg));
                    throw new CoreException(status);
                }
                catch (Exception ex) {
                    PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
                }
            }
            ++n2;
        }
    }
}

