/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.resource;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.Activator;
import org.eclipse.sphinx.emf.internal.messages.Messages;
import org.eclipse.sphinx.emf.resource.IResourceProblemMarkerFactory;
import org.eclipse.sphinx.platform.resources.MarkerDescriptor;
import org.eclipse.sphinx.platform.resources.MarkerJob;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;

public class BasicResourceProblemMarkerFactory
implements IResourceProblemMarkerFactory {
    @Override
    public void createProblemMarker(IResource resource, Resource.Diagnostic diagnostic, int severity, Map<Object, Object> problemHandlingOptions) {
        MarkerDescriptor markerDescriptor = this.createProblemMarkerDescriptor(diagnostic, severity, problemHandlingOptions);
        this.createProblemMarker(resource, markerDescriptor);
    }

    protected MarkerDescriptor createProblemMarkerDescriptor(Resource.Diagnostic diagnostic, int severity, Map<Object, Object> problemHandlingOptions) {
        MarkerDescriptor markerDescriptor = new MarkerDescriptor("org.eclipse.core.resources.problemmarker");
        markerDescriptor.getAttributes().put("transient", Boolean.TRUE);
        int line = diagnostic.getLine();
        markerDescriptor.getAttributes().put("lineNumber", line > 0 ? line : 1);
        markerDescriptor.getAttributes().put("location", NLS.bind((String)Messages.attribute_line, (Object)line));
        markerDescriptor.getAttributes().put("severity", severity);
        markerDescriptor.getAttributes().put("message", diagnostic.getMessage());
        return markerDescriptor;
    }

    @Override
    public void createProblemMarker(IResource resource, Exception exception, int severity) {
        Assert.isNotNull((Object)exception);
        MarkerDescriptor markerDescriptor = this.createProblemMarkerDescriptor(exception, severity);
        this.createProblemMarker(resource, markerDescriptor);
    }

    protected MarkerDescriptor createProblemMarkerDescriptor(Exception exception, int severity) {
        MarkerDescriptor markerDescriptor = new MarkerDescriptor("org.eclipse.core.resources.problemmarker");
        markerDescriptor.getAttributes().put("transient", Boolean.TRUE);
        markerDescriptor.getAttributes().put("lineNumber", 1);
        markerDescriptor.getAttributes().put("location", NLS.bind((String)Messages.attribute_line, (Object)1));
        markerDescriptor.getAttributes().put("severity", severity);
        markerDescriptor.getAttributes().put("message", this.createProblemMarkerMessage(exception));
        return markerDescriptor;
    }

    protected void createProblemMarker(IResource resource, MarkerDescriptor markerDescriptor) {
        if (resource.isAccessible()) {
            MarkerJob.INSTANCE.addCreateMarkerTask(resource, markerDescriptor);
        } else {
            Integer effectiveSeverity = (Integer)markerDescriptor.getAttributes().get("severity");
            String effectiveMessage = (String)markerDescriptor.getAttributes().get("message");
            if (effectiveSeverity == 2) {
                PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)effectiveMessage);
            } else if (effectiveSeverity == 1) {
                PlatformLogUtil.logAsWarning((Plugin)Activator.getPlugin(), (Object)effectiveMessage);
            } else if (effectiveSeverity == 0) {
                PlatformLogUtil.logAsInfo((Plugin)Activator.getPlugin(), (Object)effectiveMessage);
            }
        }
    }

    protected String createProblemMarkerMessage(Exception exception) {
        String causeMsg;
        Assert.isNotNull((Object)exception);
        StringBuilder msg = new StringBuilder();
        msg.append(exception.getLocalizedMessage());
        Throwable cause = exception.getCause();
        if (cause != null && (causeMsg = cause.getLocalizedMessage()) != null && causeMsg.length() > 0 && !msg.toString().contains(causeMsg)) {
            msg.append(": ");
            msg.append(causeMsg);
        }
        return msg.toString();
    }

    @Override
    public void deleteMarkers(IResource resource) {
        for (String markerType : this.getProblemMarkerTypesToDelete()) {
            MarkerJob.INSTANCE.addDeleteMarkerTask(resource, markerType);
        }
    }

    protected List<String> getProblemMarkerTypesToDelete() {
        return Collections.singletonList("org.eclipse.core.resources.problemmarker");
    }
}

