/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.validation.bridge.util;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.validation.bridge.Activator;
import org.eclipse.sphinx.emf.validation.bridge.extensions.RulesExtInternal;
import org.eclipse.sphinx.emf.validation.bridge.util.Messages;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;

public class RulesExtReader {
    public static final String TAG_RULE_EXT = "model";
    public static final String ATT_RULE_EXT_NAME = "Name";
    public static final String ATT_RULE_EXT_NSURI = "NsURI";
    public static final String ATT_RULE_EXT_MODELCLASS = "class";
    public static final String ATT_RULE_EXT_MARKER = "id";
    public static final String ATT_RULE_EXT_FILTER = "filter";
    public static final String ATT_RULE_EXT_VALIDATORCLASS = "validatorAdapterClass";
    private static RulesExtReader rulesExtReader = null;

    private RulesExtReader() {
    }

    public static RulesExtReader getSingleton() {
        if (rulesExtReader == null) {
            rulesExtReader = new RulesExtReader();
        }
        return rulesExtReader;
    }

    public RulesExtInternal readExtension(IExtension ext) {
        IConfigurationElement[] configurationElement;
        if (!ext.getExtensionPointUniqueIdentifier().equals("org.eclipse.sphinx.emf.validation.registration")) {
            return null;
        }
        RulesExtInternal tgt = new RulesExtInternal();
        IConfigurationElement[] iConfigurationElementArray = configurationElement = ext.getConfigurationElements();
        int n = configurationElement.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            this.internalReadElement(element, tgt);
            ++n2;
        }
        return tgt;
    }

    private void internalReadElement(IConfigurationElement element, RulesExtInternal tgt) {
        boolean recognized = this.readElement(element, tgt);
        if (recognized) {
            IConfigurationElement[] children;
            IConfigurationElement[] iConfigurationElementArray = children = element.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element2 = iConfigurationElementArray[n2];
                this.internalReadElement(element2, tgt);
                ++n2;
            }
        } else {
            tgt = null;
        }
    }

    private boolean readElement(IConfigurationElement element, RulesExtInternal tgt) {
        int errorCount = 0;
        if (element.getName().equals(TAG_RULE_EXT)) {
            String validatorAdapterClassName;
            if (element.getAttribute(ATT_RULE_EXT_MARKER) != null) {
                tgt.setMarker(element.getAttribute(ATT_RULE_EXT_MARKER));
            } else {
                this.logMissingAttribute(element, ATT_RULE_EXT_MARKER);
                ++errorCount;
            }
            if (element.getAttribute(ATT_RULE_EXT_FILTER) != null) {
                tgt.setFilter(element.getAttribute(ATT_RULE_EXT_FILTER));
            } else {
                this.logMissingAttribute(element, ATT_RULE_EXT_FILTER);
                ++errorCount;
            }
            if (element.getAttribute(ATT_RULE_EXT_NAME) != null) {
                tgt.setModelID(element.getAttribute(ATT_RULE_EXT_NAME));
            } else {
                this.logMissingAttribute(element, ATT_RULE_EXT_NAME);
                ++errorCount;
            }
            if (element.getAttribute(ATT_RULE_EXT_NSURI) != null) {
                tgt.setNsURI(URI.createURI((String)element.getAttribute(ATT_RULE_EXT_NSURI), (boolean)true));
            } else {
                this.logMissingAttribute(element, ATT_RULE_EXT_NSURI);
                ++errorCount;
            }
            Object ePackageOrDescriptor = null;
            if (tgt.getNsURI() != null) {
                try {
                    ePackageOrDescriptor = EPackage.Registry.INSTANCE.get((Object)tgt.getNsURI().toString());
                }
                catch (WrappedException e) {
                    String msg = NLS.bind((String)Messages.errNsURIRootPackageObject, (Object)tgt.getNsURI());
                    this.logError(element, new WrappedException(msg, (Exception)((Object)e)));
                    ++errorCount;
                }
                catch (ExceptionInInitializerError exceptionInInitializerError) {
                    String msg = NLS.bind((String)Messages.errNsURIRootPackageObject, (Object)tgt.getNsURI());
                    this.logError(element, new ExceptionInInitializerError(msg));
                    ++errorCount;
                }
            }
            if (element.getAttribute(ATT_RULE_EXT_MODELCLASS) != null) {
                if (ePackageOrDescriptor != null) {
                    String separator;
                    String value = element.getAttribute(ATT_RULE_EXT_MODELCLASS);
                    String eclassifierName = value.contains(separator = ".") ? value.substring(value.lastIndexOf(separator) + 1) : value;
                    tgt.setRootModelEClassifierName(eclassifierName);
                    tgt.setRootModelObjectName(value);
                }
            } else {
                this.logMissingAttribute(element, ATT_RULE_EXT_MODELCLASS);
                ++errorCount;
            }
            if (element.getAttribute(ATT_RULE_EXT_VALIDATORCLASS) != null && (validatorAdapterClassName = element.getAttribute(ATT_RULE_EXT_VALIDATORCLASS)) != null && validatorAdapterClassName.length() > 0) {
                try {
                    Object validatorAdapter = element.createExecutableExtension(ATT_RULE_EXT_VALIDATORCLASS);
                    tgt.setValidatorAdapter(validatorAdapter);
                }
                catch (Exception ex) {
                    this.logError(element, NLS.bind((String)Messages.errWrongValidatorAdapter, (Object[])new Object[]{validatorAdapterClassName, ex}));
                }
            }
        } else {
            tgt = null;
            return false;
        }
        if (errorCount != 0) {
            this.logError(element, NLS.bind((String)Messages.errOnExtensionModelNotRegistered, (Object)tgt.getModelId()));
            tgt = null;
        }
        return errorCount == 0;
    }

    protected void logError(IConfigurationElement element, String text) {
        IExtension extension = element.getDeclaringExtension();
        String msg = NLS.bind((String)Messages.errOnExtensionIntro, (Object[])new Object[]{extension.getExtensionPointUniqueIdentifier(), extension.getContributor().getName(), text});
        PlatformLogUtil.logAsError((Plugin)Activator.getDefault(), (Object)new Exception(msg));
    }

    protected void logError(IConfigurationElement element, Throwable throwable) {
        this.logError(element, throwable.getMessage());
    }

    protected void logMissingAttribute(IConfigurationElement element, String attributeName) {
        this.logError(element, NLS.bind((String)Messages.errMissingAttributeOnExtensionPoint, (Object)attributeName));
    }
}

