/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.xtendxpand.preferences;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.sphinx.platform.preferences.AbstractProjectWorkspacePreference;
import org.eclipse.sphinx.xtendxpand.internal.preferences.OutletsPreferenceInitializer;
import org.eclipse.sphinx.xtendxpand.outlet.ExtendedOutlet;

public class OutletsPreference
extends AbstractProjectWorkspacePreference<Collection<ExtendedOutlet>>
implements IAdaptable {
    public static final OutletsPreference INSTANCE = new OutletsPreference("org.eclipse.xtend.shared.ui.xtendXPandNature", OutletsPreferenceInitializer.QUALIFIER, "xpand.outlets", "@${project_loc}/gen");

    public OutletsPreference(String requiredProjectNatureId, String qualifier, String key, String defaultValueAsString) {
        super(requiredProjectNatureId, qualifier, key, defaultValueAsString);
    }

    protected Collection<ExtendedOutlet> toObject(IProject project, String valueAsString) {
        if (valueAsString != null) {
            String[] values;
            ArrayList<ExtendedOutlet> outlets = new ArrayList<ExtendedOutlet>();
            String[] stringArray = values = valueAsString.split(File.pathSeparator);
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                int i = value.indexOf("?");
                String nameAndLocaltion = i == -1 ? value : value.substring(0, i);
                String allAttributes = i == -1 ? "" : value.substring(i + 1);
                String[] args = nameAndLocaltion.split("@");
                String name = args[0];
                String expression = args[1];
                ExtendedOutlet outlet = new ExtendedOutlet(expression, project);
                if (name.length() > 0) {
                    outlet.setName(name);
                }
                if (allAttributes.length() > 0) {
                    String[] attributes;
                    String[] stringArray2 = attributes = allAttributes.split(";");
                    int n3 = attributes.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String attribute = stringArray2[n4];
                        String[] attrNameAndValue = attribute.split("=");
                        String attrName = attrNameAndValue[0];
                        String attrValue = attrNameAndValue[1];
                        if ("protectedRegion".equals(attrName)) {
                            outlet.setProtectedRegion(Boolean.parseBoolean(attrValue));
                        }
                        ++n4;
                    }
                }
                outlets.add(outlet);
                ++n2;
            }
            return Collections.unmodifiableCollection(outlets);
        }
        return null;
    }

    protected String toString(IProject project, Collection<ExtendedOutlet> valueAsObject) {
        if (valueAsObject != null) {
            StringBuilder builder = new StringBuilder();
            Iterator<ExtendedOutlet> iter = valueAsObject.iterator();
            while (iter.hasNext()) {
                ExtendedOutlet outlet = iter.next();
                builder.append(outlet.getName() != null ? outlet.getName() : "");
                builder.append("@");
                builder.append(outlet.getPathExpression());
                if (outlet.isProtectedRegion()) {
                    builder.append("?");
                    builder.append("protectedRegion=true");
                }
                if (!iter.hasNext()) continue;
                builder.append(File.pathSeparator);
            }
            return builder.toString();
        }
        return null;
    }

    public ExtendedOutlet getDefaultOutlet(IProject project) {
        for (ExtendedOutlet outlet : (Collection)this.get(project)) {
            if (outlet.getName() != null) continue;
            return outlet;
        }
        return null;
    }

    public Collection<ExtendedOutlet> getNamedOutlets(IProject project) {
        return this.removeDefaultOutlet((Collection)this.get(project));
    }

    private Collection<ExtendedOutlet> removeDefaultOutlet(Collection<ExtendedOutlet> allOutlets) {
        ArrayList<ExtendedOutlet> result = new ArrayList<ExtendedOutlet>(allOutlets);
        for (ExtendedOutlet outlet : allOutlets) {
            if (outlet.getName() != null) continue;
            result.remove((Object)outlet);
            break;
        }
        return result;
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }
}

