/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.xwt.model.layout.form;

import java.io.Serializable;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.gef.policy.snapping.PlacementUtils;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;
import org.eclipse.wb.internal.core.utils.xml.DocumentElement;
import org.eclipse.wb.internal.core.xml.model.EditorContext;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.broadcast.GenericPropertySetExpression;
import org.eclipse.wb.internal.core.xml.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.xml.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.xml.model.property.GenericPropertyImpl;
import org.eclipse.wb.internal.swt.model.layout.form.FormLayoutUtils;
import org.eclipse.wb.internal.swt.model.layout.form.FormSide;
import org.eclipse.wb.internal.swt.model.layout.form.IFormAttachmentInfo;
import org.eclipse.wb.internal.xwt.model.layout.form.VirtualFormAttachmentCreationSupport;
import org.eclipse.wb.internal.xwt.model.util.NameSupport;
import org.eclipse.wb.internal.xwt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.xwt.model.widgets.ControlInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FormAttachmentInfo
extends XmlObjectInfo
implements IFormAttachmentInfo<ControlInfo> {
    private static final String PROPERTY_TITLE_ALIGNMENT = "alignment";
    private static final String PROPERTY_TITLE_CONTROL = "control";
    private static final String PROPERTY_TITLE_OFFSET = "offset";
    private static final String PROPERTY_TITLE_DENOMINATOR = "denominator";
    private static final String PROPERTY_TITLE_NUMERATOR = "numerator";
    private final FormAttachmentInfo m_this = this;
    private FormSide m_side;
    private int m_numerator;
    private int m_denominator = 100;
    private int m_offset;
    private ControlInfo m_control;
    private int m_alignment = -1;
    private boolean m_deleting;

    public FormAttachmentInfo(EditorContext context, ComponentDescription description, CreationSupport creationSupport) throws Exception {
        super(context, description, creationSupport);
    }

    protected void initialize() throws Exception {
        super.initialize();
        this.addBroadcastListener(new GenericPropertySetExpression(){

            public void invoke(GenericPropertyImpl property, String[] source, Object[] value, boolean[] shouldSet) throws Exception {
                if (property.getObject() == FormAttachmentInfo.this.m_this) {
                    FormAttachmentInfo.this.setPropertyExpression(property, value[0]);
                    shouldSet[0] = false;
                }
            }
        });
    }

    protected void refresh_fetch() throws Exception {
        super.refresh_fetch();
        this.readPropertiesValue();
    }

    public FormSide getSide() {
        return this.m_side;
    }

    public void setSide(FormSide side) {
        this.m_side = side;
    }

    private void setPropertyExpression(GenericPropertyImpl property, Object value) throws Exception {
        String title = property.getTitle();
        if (PROPERTY_TITLE_NUMERATOR.equals(title)) {
            this.setNumerator((Integer)value);
            this.setControl((ControlInfo)null);
        }
        if (PROPERTY_TITLE_OFFSET.equals(title)) {
            this.setOffset((Integer)value);
        }
        if (PROPERTY_TITLE_DENOMINATOR.equals(title)) {
            this.setDenominator((Integer)value);
            this.setControl((ControlInfo)null);
        }
        if (PROPERTY_TITLE_ALIGNMENT.equals(title)) {
            if (this.getControl() != null) {
                int alignment = (Integer)value;
                this.setAlignment(alignment);
            } else {
                return;
            }
        }
        if (PROPERTY_TITLE_CONTROL.equals(title)) {
            if (value == Property.UNKNOWN_VALUE) {
                this.setControl((ControlInfo)null);
            } else {
                this.setControl((ControlInfo)((Object)value));
                this.setAlignment(this.getSide().getOppositeSide().getFormSide());
                this.setOffset(0);
            }
        }
        this.write();
        if (!this.m_deleting) {
            ExecutionUtils.refresh((ObjectInfo)this);
        }
    }

    public void readPropertiesValue() throws Exception {
        this.m_numerator = (Integer)this.getPropertyByTitle(PROPERTY_TITLE_NUMERATOR).getValue();
        this.m_denominator = (Integer)this.getPropertyByTitle(PROPERTY_TITLE_DENOMINATOR).getValue();
        this.m_offset = (Integer)this.getPropertyByTitle(PROPERTY_TITLE_OFFSET).getValue();
        Object control = this.getPropertyByTitle(PROPERTY_TITLE_CONTROL).getValue();
        this.m_control = (ControlInfo)this.getRootXML().getChildByObject(control);
        this.m_alignment = (Integer)this.getPropertyByTitle(PROPERTY_TITLE_ALIGNMENT).getValue();
        if (this.m_alignment == 0 || this.m_alignment == -1) {
            this.m_alignment = this.m_side.getOppositeSide().getFormSide();
        }
    }

    public void delete() throws Exception {
        try {
            this.m_deleting = true;
            this.setDefaults();
            super.delete();
        }
        finally {
            this.m_deleting = false;
        }
    }

    private void setDefaults() throws Exception {
        this.getPropertyByTitle(PROPERTY_TITLE_NUMERATOR).setValue((Object)0);
        this.getPropertyByTitle(PROPERTY_TITLE_DENOMINATOR).setValue((Object)100);
        this.getPropertyByTitle(PROPERTY_TITLE_OFFSET).setValue((Object)0);
        this.getPropertyByTitle(PROPERTY_TITLE_ALIGNMENT).setValue((Object)-1);
        this.getPropertyByTitle(PROPERTY_TITLE_CONTROL).setValue(Property.UNKNOWN_VALUE);
    }

    public final void setNumerator(int numerator) {
        this.m_numerator = numerator;
    }

    public final int getNumerator() {
        return this.m_numerator;
    }

    public final void setDenominator(int denominator) {
        this.m_denominator = denominator;
    }

    public final int getDenominator() {
        return this.m_denominator;
    }

    public final void setOffset(int offset) {
        this.m_offset = offset;
    }

    public final int getOffset() {
        return this.m_offset;
    }

    public final void setControl(ControlInfo control) {
        this.m_control = control;
    }

    public final ControlInfo getControl() {
        return this.m_control;
    }

    public final void setAlignment(int alignment) {
        if (alignment == 0 || alignment == -1) {
            alignment = this.m_side.getOppositeSide().getFormSide();
        }
        if (!this.isValidAlignment(alignment)) {
            return;
        }
        this.m_alignment = alignment;
    }

    public final int getAlignment() {
        return this.m_alignment;
    }

    public boolean isVirtual() {
        return this.getCreationSupport() instanceof VirtualFormAttachmentCreationSupport;
    }

    public boolean isParentTrailing() {
        return !this.isVirtual() && this.getControl() == null && this.getDenominator() == this.getNumerator();
    }

    public boolean isParentLeading() {
        return !this.isVirtual() && this.getControl() == null && this.getNumerator() == 0 && this.getDenominator() == 100;
    }

    public boolean isPercentaged() {
        return this.getNumerator() > 0 && this.getNumerator() < 100;
    }

    public void write() throws Exception {
        ControlInfo control = this.getControl();
        DocumentElement element = this.getElement();
        if (control == null) {
            element.setAttribute(PROPERTY_TITLE_CONTROL, null);
            element.setAttribute(PROPERTY_TITLE_ALIGNMENT, null);
            if (this.getDenominator() == 100) {
                if (this.getOffset() == 0) {
                    element.setAttribute(PROPERTY_TITLE_NUMERATOR, "" + this.getNumerator());
                    element.setAttribute(PROPERTY_TITLE_DENOMINATOR, null);
                    element.setAttribute(PROPERTY_TITLE_OFFSET, null);
                } else {
                    element.setAttribute(PROPERTY_TITLE_NUMERATOR, "" + this.getNumerator());
                    element.setAttribute(PROPERTY_TITLE_DENOMINATOR, null);
                    element.setAttribute(PROPERTY_TITLE_OFFSET, "" + this.getOffset());
                }
            } else {
                element.setAttribute(PROPERTY_TITLE_NUMERATOR, "" + this.getNumerator());
                element.setAttribute(PROPERTY_TITLE_DENOMINATOR, "" + this.getDenominator());
                element.setAttribute(PROPERTY_TITLE_OFFSET, "" + this.getOffset());
            }
        } else {
            element.setAttribute(PROPERTY_TITLE_NUMERATOR, null);
            element.setAttribute(PROPERTY_TITLE_DENOMINATOR, null);
            String referenceExpression = this.getReferenceExpression(control);
            element.setAttribute(PROPERTY_TITLE_CONTROL, referenceExpression);
            if (this.getAlignment() == this.m_side.getOppositeSide().getFormSide()) {
                if (this.getOffset() == 0) {
                    element.setAttribute(PROPERTY_TITLE_OFFSET, null);
                    element.setAttribute(PROPERTY_TITLE_ALIGNMENT, null);
                } else {
                    element.setAttribute(PROPERTY_TITLE_OFFSET, "" + this.getOffset());
                    element.setAttribute(PROPERTY_TITLE_ALIGNMENT, null);
                }
            } else {
                element.setAttribute(PROPERTY_TITLE_OFFSET, "" + this.getOffset());
                element.setAttribute(PROPERTY_TITLE_ALIGNMENT, "SWT." + CodeUtils.getShortClass((String)FormLayoutUtils.getAlignmentSource((int)this.getAlignment())));
            }
        }
    }

    private String getReferenceExpression(ControlInfo control) {
        return "{Binding ElementName=" + NameSupport.ensureName((XmlObjectInfo)control) + "}";
    }

    public String toString() {
        final String[] result = new String[]{""};
        if (this.isVirtual()) {
            result[0] = String.valueOf(result[0]) + "(none)";
            return result[0];
        }
        ExecutionUtils.runIgnore((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                ControlInfo control = FormAttachmentInfo.this.getControl();
                int offset = FormAttachmentInfo.this.getOffset();
                if (control == null) {
                    result[0] = String.valueOf(result[0]) + "(" + FormAttachmentInfo.this.getNumerator();
                    int denominator = FormAttachmentInfo.this.getDenominator();
                    if (denominator != 100) {
                        result[0] = String.valueOf(result[0]) + ", " + denominator;
                    }
                    if (offset != 0 || denominator != 100) {
                        result[0] = String.valueOf(result[0]) + ", " + offset;
                    }
                    result[0] = String.valueOf(result[0]) + ")";
                } else {
                    result[0] = String.valueOf(result[0]) + "(" + control.getPresentation().getText() + ", " + offset + ")";
                }
            }
        });
        return result[0];
    }

    private boolean isValidAlignment(int alignment) {
        if (alignment != 0x1000000) {
            boolean b2;
            boolean b1 = PlacementUtils.isHorizontalSide((int)this.getSide().getEngineSide());
            return b1 == (b2 = PlacementUtils.isHorizontalSide((int)FormLayoutUtils.convertSwtAlignment((int)alignment)));
        }
        return true;
    }

    public void adjustAfterComponentMove() throws Exception {
        this.write();
    }

    public FormAttachmentClipboardInfo getClipboardInfo() {
        if (this.isVirtual()) {
            return null;
        }
        FormAttachmentClipboardInfo info = new FormAttachmentClipboardInfo();
        info.numerator = this.getNumerator();
        info.denominator = this.getDenominator();
        info.offset = this.getOffset();
        ControlInfo targetControl = this.getControl();
        if (targetControl != null) {
            CompositeInfo parent = (CompositeInfo)targetControl.getParent();
            info.controlID = parent.getChildrenControls().indexOf((Object)targetControl);
        }
        info.alignment = this.getAlignment();
        return info;
    }

    public void applyClipboardInfo(ControlInfo thisControl, FormAttachmentClipboardInfo info) throws Exception {
        if (info == null) {
            return;
        }
        this.setNumerator(info.numerator);
        this.setDenominator(info.denominator);
        this.setOffset(info.offset);
        this.setAlignment(info.alignment);
        if (info.controlID != -1) {
            CompositeInfo parent = (CompositeInfo)thisControl.getParent();
            ControlInfo targetControl = parent.getChildrenControls().get(info.controlID);
            this.setControl(targetControl);
        }
        this.write();
    }

    static class FormAttachmentClipboardInfo
    implements Serializable {
        private static final long serialVersionUID = 0L;
        int numerator;
        int denominator;
        int offset;
        int controlID = -1;
        int alignment;

        FormAttachmentClipboardInfo() {
        }
    }
}

