/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.webclient.wrapper_nonnative;

import ice.storm.StormBase;
import ice.storm.Viewport;
import java.io.InputStream;
import java.util.Properties;
import org.mozilla.util.Assert;
import org.mozilla.util.Log;
import org.mozilla.webclient.BrowserControl;
import org.mozilla.webclient.BrowserControlFactory;
import org.mozilla.webclient.BrowserType;
import org.mozilla.webclient.Navigation;
import org.mozilla.webclient.Prompt;
import org.mozilla.webclient.UnimplementedException;
import org.mozilla.webclient.WrapperFactory;
import org.mozilla.webclient.wrapper_nonnative.ImplObjectNonnative;

public class NavigationImpl
extends ImplObjectNonnative
implements Navigation {
    private StormBase ICEbase;
    private Viewport viewPort;

    public NavigationImpl(WrapperFactory wrapperFactory, BrowserControl browserControl) {
        super(wrapperFactory, browserControl);
        BrowserType browserType = null;
        try {
            browserType = (BrowserType)browserControl.queryInterface("webclient.BrowserType");
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            System.out.println("\n\n Something went wrong when getting the Interfaces \n");
        }
        this.ICEbase = (StormBase)browserType.getStormBase();
        this.viewPort = (Viewport)browserType.getViewPort();
    }

    public void loadURL(String string) {
        BrowserControl browserControl = this.myBrowserControl;
        synchronized (browserControl) {
            this.ICEbase.renderContent(string, null, this.viewPort.getName());
        }
    }

    public void loadFromStream(InputStream inputStream, String string, String string2, int n, Properties properties) {
        throw new UnimplementedException("\nUnimplementedException -----\n API Function Navigation::loadFromStream has not yet been implemented.\n");
    }

    public void refresh(long l) {
        BrowserControl browserControl = this.myBrowserControl;
        synchronized (browserControl) {
            String string = this.ICEbase.getHistoryManager().getCurrentLocation(this.viewPort.getId());
            this.ICEbase.renderContent(string, null, this.viewPort.getName());
        }
    }

    public void stop() {
        BrowserControl browserControl = this.myBrowserControl;
        synchronized (browserControl) {
            this.ICEbase.stopLoading(this.viewPort.getName());
        }
    }

    public void setPrompt(Prompt prompt) {
        throw new UnimplementedException("\nUnimplementedException -----\n API Function Navigation::setPrompt has not yet been implemented.\n");
    }

    public static void main(String[] stringArray) {
        Assert.setEnabled(true);
        Log.setApplicationName("NavigationImpl");
        Log.setApplicationVersion("0.0");
        Log.setApplicationVersionDate("$Id: NavigationImpl.java,v 1.1 2001/07/27 21:01:12 ashuk%eng.sun.com Exp $");
        try {
            BrowserControlFactory.setAppData("nonnative", stringArray[0]);
            BrowserControl browserControl = BrowserControlFactory.newBrowserControl();
            Assert.assert_it(browserControl != null);
            Navigation navigation = (Navigation)browserControl.queryInterface("webclient.WindowControl");
            Assert.assert_it(navigation != null);
        }
        catch (Exception exception) {
            System.out.println("got exception: " + exception.getMessage());
        }
    }
}

