/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.geom;

import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import sun.awt.geom.Curve;

final class Order2
extends Curve {
    private double x0;
    private double y0;
    private double cx0;
    private double cy0;
    private double x1;
    private double y1;
    private double xmin;
    private double xmax;
    private double xcoeff0;
    private double xcoeff1;
    private double xcoeff2;
    private double ycoeff0;
    private double ycoeff1;
    private double ycoeff2;

    public static void insert(Vector vector, double[] dArray, double d, double d2, double d3, double d4, double d5, double d6, int n) {
        int n2 = Order2.getHorizontalParams(d2, d4, d6, dArray);
        if (n2 == 0) {
            vector.add(new Order2(d, d2, d3, d4, d5, d6, n));
            return;
        }
        double d7 = dArray[0];
        dArray[0] = d;
        dArray[1] = d2;
        dArray[2] = d3;
        dArray[3] = d4;
        dArray[4] = d5;
        dArray[5] = d6;
        Order2.split(dArray, 0, d7);
        Order2 order2 = Order2.getInstance(d, d2, dArray[2], dArray[3], dArray[4], dArray[5], n);
        Order2 order22 = Order2.getInstance(dArray[4], dArray[5], dArray[6], dArray[7], d5, d6, n);
        if (n == 1) {
            vector.add(order2);
            vector.add(order22);
        } else {
            vector.add(order22);
            vector.add(order2);
        }
    }

    public static Order2 getInstance(double d, double d2, double d3, double d4, double d5, double d6, int n) {
        if (d2 > d6) {
            return new Order2(d5, d6, d3, d4, d, d2, -n);
        }
        return new Order2(d, d2, d3, d4, d5, d6, n);
    }

    public static void getEqn(double[] dArray, double d, double d2, double d3) {
        dArray[0] = d;
        dArray[1] = d2 + d2 - d - d;
        dArray[2] = d - d2 - d2 + d3;
    }

    public static int getHorizontalParams(double d, double d2, double d3, double[] dArray) {
        if (d <= d2 && d2 <= d3) {
            return 0;
        }
        double d4 = (d -= d2) + (d3 -= d2);
        if (d4 == 0.0) {
            return 0;
        }
        double d5 = d / d4;
        if (d5 <= 0.0 || d5 >= 1.0) {
            return 0;
        }
        dArray[0] = d5;
        return 1;
    }

    public static void split(double[] dArray, int n, double d) {
        double d2;
        double d3;
        dArray[n + 8] = d3 = dArray[n + 4];
        dArray[n + 9] = d2 = dArray[n + 5];
        double d4 = dArray[n + 2];
        double d5 = dArray[n + 3];
        d3 = d4 + (d3 - d4) * d;
        d2 = d5 + (d2 - d5) * d;
        double d6 = dArray[n + 0];
        double d7 = dArray[n + 1];
        d6 += (d4 - d6) * d;
        d7 += (d5 - d7) * d;
        d4 = d6 + (d3 - d6) * d;
        d5 = d7 + (d2 - d7) * d;
        dArray[n + 2] = d6;
        dArray[n + 3] = d7;
        dArray[n + 4] = d4;
        dArray[n + 5] = d5;
        dArray[n + 6] = d3;
        dArray[n + 7] = d2;
    }

    public Order2(double d, double d2, double d3, double d4, double d5, double d6, int n) {
        super(n);
        if (d4 < d2) {
            d4 = d2;
        } else if (d4 > d6) {
            d4 = d6;
        }
        this.x0 = d;
        this.y0 = d2;
        this.cx0 = d3;
        this.cy0 = d4;
        this.x1 = d5;
        this.y1 = d6;
        this.xmin = Math.min(Math.min(d, d5), d3);
        this.xmax = Math.max(Math.max(d, d5), d3);
        this.xcoeff0 = d;
        this.xcoeff1 = d3 + d3 - d - d;
        this.xcoeff2 = d - d3 - d3 + d5;
        this.ycoeff0 = d2;
        this.ycoeff1 = d4 + d4 - d2 - d2;
        this.ycoeff2 = d2 - d4 - d4 + d6;
    }

    public int getOrder() {
        return 2;
    }

    public double getXTop() {
        return this.x0;
    }

    public double getYTop() {
        return this.y0;
    }

    public double getXBot() {
        return this.x1;
    }

    public double getYBot() {
        return this.y1;
    }

    public double getXMin() {
        return this.xmin;
    }

    public double getXMax() {
        return this.xmax;
    }

    public double getX0() {
        return this.direction == 1 ? this.x0 : this.x1;
    }

    public double getY0() {
        return this.direction == 1 ? this.y0 : this.y1;
    }

    public double getCX0() {
        return this.cx0;
    }

    public double getCY0() {
        return this.cy0;
    }

    public double getX1() {
        return this.direction == -1 ? this.x0 : this.x1;
    }

    public double getY1() {
        return this.direction == -1 ? this.y0 : this.y1;
    }

    public double XforY(double d) {
        if (d == this.y0) {
            return this.x0;
        }
        if (d == this.y1) {
            return this.x1;
        }
        return this.XforT(this.TforY(d));
    }

    public double TforY(double d) {
        double[] dArray = new double[3];
        Order2.getEqn(dArray, this.y0, this.cy0, this.y1);
        dArray[0] = dArray[0] - d;
        int n = QuadCurve2D.solveQuadratic(dArray, dArray);
        return Curve.firstValidRoot(dArray, n);
    }

    public double XforT(double d) {
        return (this.xcoeff2 * d + this.xcoeff1) * d + this.xcoeff0;
    }

    public double YforT(double d) {
        return (this.ycoeff2 * d + this.ycoeff1) * d + this.ycoeff0;
    }

    public double dXforT(double d, int n) {
        switch (n) {
            case 0: {
                return (this.xcoeff2 * d + this.xcoeff1) * d + this.xcoeff0;
            }
            case 1: {
                return 2.0 * this.xcoeff2 * d + this.xcoeff1;
            }
            case 2: {
                return 2.0 * this.xcoeff2;
            }
        }
        return 0.0;
    }

    public double dYforT(double d, int n) {
        switch (n) {
            case 0: {
                return (this.ycoeff2 * d + this.ycoeff1) * d + this.ycoeff0;
            }
            case 1: {
                return 2.0 * this.ycoeff2 * d + this.ycoeff1;
            }
            case 2: {
                return 2.0 * this.ycoeff2;
            }
        }
        return 0.0;
    }

    public double nextVertical(double d, double d2) {
        double d3 = -this.ycoeff1 / (2.0 * this.ycoeff2);
        if (d3 > d && d3 < d2) {
            return d3;
        }
        return d2;
    }

    public void enlarge(Rectangle2D rectangle2D) {
        rectangle2D.add(this.x0, this.y0);
        double d = -this.xcoeff1 / (2.0 * this.xcoeff2);
        if (d > 0.0 && d < 1.0) {
            rectangle2D.add(this.XforT(d), this.YforT(d));
        }
        rectangle2D.add(this.x1, this.y1);
    }

    public Curve getSubCurve(double d, double d2, int n) {
        double d3;
        int n2;
        double d4;
        if (d == this.y0 && d2 == this.y1) {
            return this.getWithDirection(n);
        }
        double[] dArray = new double[10];
        if (d == this.y0) {
            d4 = 0.0;
        } else {
            Order2.getEqn(dArray, this.y0, this.cy0, this.y1);
            dArray[0] = dArray[0] - d;
            n2 = QuadCurve2D.solveQuadratic(dArray, dArray);
            d4 = Curve.firstValidRoot(dArray, n2);
        }
        if (d2 == this.y1) {
            d3 = 1.0;
        } else {
            Order2.getEqn(dArray, this.y0, this.cy0, this.y1);
            dArray[0] = dArray[0] - d2;
            n2 = QuadCurve2D.solveQuadratic(dArray, dArray);
            d3 = Curve.firstValidRoot(dArray, n2);
        }
        dArray[0] = this.x0;
        dArray[1] = this.y0;
        dArray[2] = this.cx0;
        dArray[3] = this.cy0;
        dArray[4] = this.x1;
        dArray[5] = this.y1;
        if (d3 < 1.0) {
            Order2.split(dArray, 0, d3);
        }
        if (d4 <= 0.0) {
            return new Order2(dArray[0], d, dArray[2], dArray[3], dArray[4], d2, n);
        }
        Order2.split(dArray, 0, d4 / d3);
        return new Order2(dArray[4], d, dArray[6], dArray[7], dArray[8], d2, n);
    }

    public Curve getReversedCurve() {
        return new Order2(this.x0, this.y0, this.cx0, this.cy0, this.x1, this.y1, -this.direction);
    }

    public int getSegment(double[] dArray) {
        dArray[0] = this.cx0;
        dArray[1] = this.cy0;
        if (this.direction == 1) {
            dArray[2] = this.x1;
            dArray[3] = this.y1;
        } else {
            dArray[2] = this.x0;
            dArray[3] = this.y0;
        }
        return 2;
    }

    public String controlPointString() {
        return "(" + Curve.round(this.cx0) + ", " + Curve.round(this.cy0) + "), ";
    }
}

