/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is Sun Microsystems,
 * Inc. Portions created by Sun are
 * Copyright (C) 1999 Sun Microsystems, Inc. All
 * Rights Reserved.
 *
 * Contributor(s):
 * Igor Kushnirskiy <idk@eng.sun.com>
 * Brad GNUberg <bkn3@columbia.edu>
 */

#include "bcIBlackConnectInit.h"
#include "nsIModule.h"
#include "nsIServiceManager.h"
#include "nsIXPIDLServiceManager.h"
#include "bcIXPCOMWrappers.h"
#include "bcXPCOMWrappersCID.h"


extern "C" NS_EXPORT nsresult NSGetModule(nsIComponentManager *compMgr,
                                          nsIFile *location,
                                          nsIModule** result)  //I am using it for initialization only
{
	printf("--bcBlackConnectInit::NSGetModule beginning\n");
    static int counter = 0;  //we do not need to call it on unload time;
    nsresult r;
    if (counter == 0) {
		printf("--bcBlackConnectInit::NSGetModule 2\n");
        counter ++;
        bcIBlackConnectInit *blackConnectInit;
        r = nsComponentManager::CreateInstance("bcBlackConnectInit",
                                               nsnull,
                                               NS_GET_IID(bcIBlackConnectInit),
                                               (void**)&blackConnectInit);
		printf("--bcBlackConnectInit::NSGetModule 3\n");
        if (NS_SUCCEEDED(r)) {
			printf("--bcBlackConnectInit::NSGetModule 4\n");
            nsIComponentManager* cm;
		
			nsIXPIDLServiceManager *sm;
			r = NS_GetGlobalComponentManager(&cm);
			if (NS_SUCCEEDED(r)) {
				printf("--bcBlackConnectInit::NSGetModule 5\n");
				blackConnectInit->InitComponentManager(cm);
			}
			printf("--bcBlackConnectInit::NSGetModule 6\n");
			nsCOMPtr<bcIXPCOMWrappers> xpcomWrappers = do_GetService(BC_XPCOMWRAPPERS_CONTRACTID, &r);
			nsIID * wrapperIID;
			printf("--bcBlackConnectInit::NSGetModule 7\n");
			if (NS_SUCCEEDED(r)) {
				printf("--bcBlackConnectInit::NSGetModule 8\n");
				r = xpcomWrappers->GetWrapper((nsISupports*)NULL,NS_GET_IID(nsIServiceManager),&wrapperIID, (nsISupports**)&sm);
				if (NS_SUCCEEDED(r)) {
					printf("--bcBlackConnectInit::NSGetModule 9\n");
					printf("--[c++]about to call blackConnectInit->InitServiceManager(sm)\n");
					blackConnectInit->InitServiceManager(sm);
				}
			}
			printf("--bcBlackConnectInit::NSGetModule 10\n");
		}
    }
	printf("--bcBlackConnectInit::NSGetModule 11\n");
    return NS_ERROR_FAILURE;
}



