#define __eutl_dynarray_impl
#include "dynarray.h"
#include <xmalloc.h>
#include <stdio.h>
#include <libc.h>

char *dynarray_packagever = "DynArray V1.0";
char *dynarray_Ebadisize = "0 is a bad item size";
char *dynarray_Eoutofbounds = "Array index out of bounds";

struct __eutl_dynarray_DynArray {
  void *a;/* array */
  unsigned int amax,asize,aincr,isize;/* maximum assigned index of array,
					 current actual size of array,
					 array size increment for resizing set,
					 item size */
};

static ErrorFunction Erf = LongJmpErrorFunction;

eutl_dynarray_DynArray eutl_dynarray_dyn_create(unsigned int isize,
				  unsigned int inum,
				  unsigned int iincr)
{
  eutl_dynarray_DynArray ret;

  if (isize==0)
    Erf(dynarray_packagever,dynarray_Ebadisize,
	"Item size of 0 is illegal\n");

  if (iincr==0) {
    iincr = EUTL_DYNARRAY_MEMCHUNK/isize;
    if ( iincr < EUTL_DYNARRAY_MININCR )
      iincr = EUTL_DYNARRAY_MININCR;
  }
  if (inum==0) 
    inum = iincr;
  ret = xmalloc(sizeof(struct __eutl_dynarray_DynArray));
  ret->amax = 0;
  ret->asize = 0;
  ret->aincr = iincr;
  ret->isize = isize;
  ret->a = NULL;
  return ret;
}

void eutl_dynarray_dyn_destroy(eutl_dynarray_DynArray gone)
{
  free(gone->a);
  free(gone);
}

void eutl_dynarray_dyn_set(eutl_dynarray_DynArray array,
			   unsigned int index,
			   void *iptr)
{
  if (array->amax <= index) {
    /* set amax to be the multiple of aincr right above index */
    array->amax = index - (index % array->aincr) + array->aincr;
    array->a = xrealloc(array->a,array->amax*array->isize);
  }
  /* copy in the data */
  bcopy(iptr,(char *)array->a + index * array->isize,array->isize);
  if (array->asize <= index)
    array->asize = index+1;
}

void *eutl_dynarray_dyn_get(eutl_dynarray_DynArray array,
			   unsigned int index)
{
  if (array->asize <= index)
    Erf(dynarray_packagever,dynarray_Eoutofbounds,
	"Index %d is out of bounds, max set array size is %d\n",
	index,array->asize);
  return (void *)((char *)array->a + index * array->isize);
}

