#include "errlib.h"
#include <stdio.h>

void ST1()
{
  throwerr("foo","bar","Just Checking");
}

void SimpleTest()
{
  WITH_HANDLING {
    ST1();
    fprintf(stderr,"SimpleTest failed: didn't raise exception\n");
    exit(1);
  } HANDLE {
    printf("SimpleTest passed\n");
  }
  END_HANDLING;
}

char *rrt_p = "ReRaiseTestPackage";
char *rrt_eid = "ReRaiseTestErrorId";

void RRT2()
{
  throwerr(rrt_p,rrt_eid,"ReRaiseTest\n");
}

void RRT1()
{
  WITH_HANDLING {
    RRT2();
    fprintf(stderr,"ReRaiseTest failed: RRT2 didn't raise exception\n");
    exit(1);
  } HANDLE {
    RERAISE();
  } 
  END_HANDLING;
}

void ReRaiseTest()
{
  WITH_HANDLING {
    RRT1();
    fprintf(stderr,"ReRaiseTest failed: didn't raise exception\n");
    exit(1);
  } HANDLE {
    if (exception_package == rrt_p &&
	exception_eid == rrt_eid) {
      printf("ReRaiseTest passed\n");
    } else {
      printf("ReRaiseTest failed: wront package or errorid\n");
    }
  } 
  END_HANDLING;
}

char *hst_p = "HandleSomeTestPackage";
char *hst_e1 = "Handle Exception 1";
char *hst_e2 = "Handle Exception 2";

void HST2(int x)
{
  throwerr(hst_p,x==1?hst_e1:hst_e2,"HandleSomeTest");
}

void HST1(int x)
{
  WITH_HANDLING {
    HST2(x);
  } HANDLE {
    BEGIN_MATCH;
    EXCP_MATCH(hst_p,hst_e1) {
      CLEANUP_HANDLING;return;
    }
    END_MATCH;
  }
  END_HANDLING;
  fprintf(stderr,"HST2 didn't raise exception\n");
  exit(1);
}

void HandleSomeTest()
{
  WITH_HANDLING {
    HST1(1);
  } HANDLE {
    fprintf(stderr,"HST1 didn't handle exception\n");
    exit(1);
  }
  END_HANDLING;
  WITH_HANDLING {
    HST1(2);
    fprintf(stderr,"HST2 didn't reraise exception\n");
  } HANDLE {
    BEGIN_MATCH;
    EXCP_MATCH(hst_p,hst_e2) {
    } 
    END_MATCH;
  }
  END_HANDLING;
  printf("HandleSomeTest passed.\n");
}

main()
{
  SimpleTest();
  ReRaiseTest();
  HandleSomeTest();
  exit(0);
}
