#ifndef __libc_h

#include <stdarg.h>
#include <stdio.h>
#include <sys/types.h>
#include <time.h>

#if defined(sparc) || defined(__sparc__)
#ifndef __SVR4
#define NEED_PRINTF 1
#define NEED_SOCKET 1
#define NEED_FILEVEC 1
#endif
#define NEED_FILE 1
#define NEED_BFN 1
#define NEED_STRING 1
#define NEED_ERROR 1
#define NEED_MALLOC 1
#endif

#ifdef __hppa__
#define NEED_ERROR 1
#define NEED_FILE 1
#define NEED_BFN 1
#endif

#if NEED_ERROR
char *strerror(int errno);
#endif

#if NEED_MALLOC
void free(void *);
#endif

#if NEED_PRINTF
int vsprintf(char *s, char *format, va_list ap);
int fprintf(FILE *stream, char *format, ...);
int vfprintf(FILE *stream, char *format, va_list ap);
int printf(char *format, ...);
#endif

#if NEED_SOCKET
struct timeval;
int socket(int domain, int type, int protocol);
int setsockopt(int s, int level, int optname, char *optval, int optlen);
int bind(int s, void *name, int namelen);
int listen(int s, int backlog);
int connect(int s, void *name, int namelen);
int accept(int s, void *addr, int *addrlen);
int select(int width,fd_set *readfds,fd_set *writefds,fd_set *exceptfds,
	   struct timeval *timeout);
#endif

#if NEED_FILE
struct iopvec;
int close(int fd);
int write(int fd, char *buf, int nbyte);
int read(int fd, char *buf, int nbyte);
int fclose(FILE *stream);
int fflush(FILE *stream);
#endif

#if NEED_FILEVEC
struct iovec;
int readv(int fd, struct iovec *iov, int iovcnt);
int writev(int fd, struct iovec *iov, int iovcnt);
#endif

#if NEED_BFN
void bzero(void *ptr,long size);
void bcopy(void *src,void *dest,long size);
void *memset(void *set,int c,size_t n);
int bcmp(char *b1,char *b2,int length);
#endif

#if NEED_STRING
char *index(char *s,char c);
char *rindex(char *s,char c);
int atoi(const char *s);
#endif

#endif
  /* ndef __libc_h */
