#include <stdio.h>
#include "tcplib.h"
#include "xmalloc.h"
#include "timelib.h"

const int port=8855;

void Send(int npackets,int rmin,int rmax)
{
  int l,s;
  char *buf;
  TcpSocket conn;

  buf = xmalloc(rmax);

  conn = GetConnection(NULL,port);
  TcpLibBufferOutput(conn,1);
  srandom(time(NULL)>>1 ^ getpid()<<3);
  for(l=0;l<npackets;l++) {
    s = random()%(rmin-rmax+1)+rmin;
/*    printf("Send %d\n",l);*/
    SendSizedMsg(conn,buf,s);
/* Depend on automatic flushing */
  }
  TcpLibFlush(conn);
  exit(0);
}
  
void Server(int port)
{
  TcpSocket *conns;
  int conncount = 2;
  int i,j;

  conns = xmalloc(sizeof(TcpSocket)*2);
  conns[0] = MakeForeignFDConnection(fileno(stdin));
  conns[1] = BecomeServer(port);
  
  printf("Type quit to quit\n");
  while(1) {
    WaitForInput(conns,conncount,TCPLIB_FOREVER);
    if (HasInput(conns[0])) {
      char buf[100];
      fgets(buf,100,stdin);
      if (strcmp(buf,"quit\n")==0) {
	exit(0);
      }
      for(i=2;i<conncount;i++)
	SendString(conns[i],buf);
    }
    if (HasInput(conns[1])) {
      printf("Accepting Connection\n");
      conncount++;
      conns = xrealloc(conns,sizeof(TcpSocket)*conncount);
      conns[conncount-1] = AcceptConnection(conns[1],NULL);
    } 
    for(i=2;i<conncount;i++) {
      if (HasInput(conns[i])) {
        WITH_HANDLING {
          char *buf;
	  buf = GetString(conns[i]);
	  printf("%s",buf);
        } HANDLE {
          BEGIN_MATCH;
          XMATCH(tcplib,NothingRead) {
            printf("Connection %d dropped\n",i);
            conncount--;
            for(j=i;j<conncount;j++)
              conns[j] = conns[j+1];
            i--;
          }
          XMATCH(tcplib,ReadError) {
            printf("Connection %d dropped\n",i);
            conncount--;
            for(j=i;j<conncount;j++)
              conns[j] = conns[j+1];
            i--;
          }         
          END_MATCH;
        }
        END_HANDLING;
      }
    }
  }
}

void Client(char *server,int port)
{
  TcpSocket conns[2];

  conns[0] = MakeForeignFDConnection(fileno(stdin));
  conns[1] = GetConnection(server,port);
  printf("Type quit to quit\n");
  while(1) {
    WaitForInput(conns,2,TCPLIB_FOREVER);
    if (HasInput(conns[0])) {
      char buf[100];
      fgets(buf,100,stdin);
      if (strcmp(buf,"quit\n")==0) {
	exit(0);
      }
      SendString(conns[1],buf);
    }
    if (HasInput(conns[1])) {
      char *buf;
      buf = GetString(conns[1]);
      printf("%s",buf);
    }
  }
}

    
main(int argc,char *argv[])
{
  char *server;
  int port;
  if ((argc != 3)) {
    printf("Usage: %s (host|-s) port\n-s causes a server to be created\n",
	   argv[0]);
    exit(1);
  }
  server = argv[1];
  port = atoi(argv[2]);

  if (strcmp(server,"-s")==0) {
    Server(port);
  } else {
    Client(server,port);
  }
  exit(0);
}

